/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.concurrent.atomic.AtomicReferenceArray;
import weblogic.utils.collections.Turnstile;

public class TicketedArrayQueue<T> {
    public final Turnstile writerS;
    public final Turnstile readerS;
    AtomicReferenceArray<T> el;

    public TicketedArrayQueue(int plen) {
        this.el = new AtomicReferenceArray(plen);
        this.writerS = new Turnstile(plen - 1, 1L);
        this.readerS = new Turnstile(-1L, 1L);
    }

    public int indexFor(long g) {
        return (int)(g & (long)(this.el.length() - 1));
    }

    public T get(long g) {
        return this.el.get(this.indexFor(g));
    }

    public void releaseReaders(long generation, T v) {
        this.el.compareAndSet(this.indexFor(generation), null, v);
        long rt = this.readerS.currentTicket();
        if (rt + 1L == generation) {
            while (true) {
                long wt = this.writerS.currentTicket();
                assert (generation <= wt) : "this is plain common sense - the writer could get here only after being released by the same or greater ticket";
                while (generation < wt && this.get(generation + 1L) != null) {
                    ++generation;
                }
                if (!this.readerS.advanceFrom(rt, generation)) break;
                assert (this.writerS.currentTicket() >= generation) : "expect that writerS >= readerS after any advance";
                rt = generation;
            }
        }
    }

    public T releaseWriters(long generation) {
        int idx = this.indexFor(generation);
        T v = this.el.get(idx);
        this.el.compareAndSet(idx, v, null);
        long wt = this.writerS.currentTicket();
        if (wt + 1L == (generation += (long)this.el.length())) {
            while (true) {
                long rt = this.readerS.currentTicket() + (long)this.el.length();
                assert (generation <= rt) : "this is plain common sense - the reader could get here only after being released by the same or greater ticket";
                while (generation < rt && this.get(generation + 1L) == null) {
                    ++generation;
                }
                if (!this.writerS.advanceFrom(wt, generation)) break;
                wt = generation;
            }
        }
        return v;
    }
}

