/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.Iterator;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.FilteringIterator;
import weblogic.utils.collections.Pool;

public class StackPool
extends AbstractCollection
implements Pool {
    private final int capacity;
    private int pointer;
    private final Object[] values;

    public StackPool(int s) {
        if (s < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = s;
        this.values = new Object[this.capacity];
        this.pointer = 0;
    }

    protected int getPointer() {
        return this.pointer;
    }

    protected void setPointer(int val) {
        this.pointer = val;
    }

    protected Object getValueAt(int pos) {
        return this.values[pos];
    }

    protected Object decrementPointerAndGetValue() {
        return this.values[--this.pointer];
    }

    protected void setValueAt(int pos, Object val) {
        this.values[pos] = val;
    }

    @Override
    public int size() {
        return this.pointer;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public Iterator iterator() {
        return new FilteringIterator(new ArrayIterator(this.values)){

            @Override
            protected boolean accept(Object o) {
                return o != null;
            }
        };
    }

    @Override
    public synchronized boolean add(Object o) {
        if (this.pointer == this.capacity) {
            return false;
        }
        this.values[this.pointer++] = o;
        return true;
    }

    public synchronized Object remove() {
        if (this.pointer > 0) {
            Object o = this.values[--this.pointer];
            this.values[this.pointer] = null;
            return o;
        }
        return null;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

