/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.concurrent.atomic.AtomicInteger;
import weblogic.utils.collections.ConcurrentPool;
import weblogic.utils.collections.Pool;

public class PartitionedConcurrentPool<E>
implements Pool<E> {
    private static final int DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    private static final int MAX_TRY = 2;
    private final ConcurrentPool<E>[] pools;
    private AtomicInteger nextAdd = new AtomicInteger();
    private AtomicInteger nextRemove = new AtomicInteger();

    public PartitionedConcurrentPool(int size) {
        this(size, DEFAULT_POOL_SIZE);
    }

    public PartitionedConcurrentPool(int size, int subpools) {
        this.pools = new ConcurrentPool[subpools];
        int poolSize = size / subpools;
        for (int i = 0; i < subpools; ++i) {
            this.pools[i] = new ConcurrentPool(poolSize);
        }
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.pools.length; ++i) {
            size += this.pools[i].size();
        }
        return size;
    }

    private int advanceAddPosition() {
        return (this.nextAdd.incrementAndGet() & Integer.MAX_VALUE) % this.pools.length;
    }

    private int advanceRemovePosition() {
        return (this.nextRemove.incrementAndGet() & Integer.MAX_VALUE) % this.pools.length;
    }

    @Override
    public boolean add(E e) {
        int startIndex = this.advanceAddPosition();
        for (int i = 0; i < this.pools.length; ++i) {
            if (this.pools[startIndex].offer(e)) {
                return true;
            }
            startIndex = (startIndex + 1) % this.pools.length;
        }
        return false;
    }

    @Override
    public E remove() {
        int startIndex = this.advanceRemovePosition();
        for (int i = 0; i < 2 && i < this.pools.length; ++i) {
            E e = this.pools[startIndex].poll();
            if (e != null) {
                return e;
            }
            startIndex = (startIndex + 1) % this.pools.length;
        }
        return null;
    }
}

