/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Arrays;

public class NumericValueHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    public NumericValueHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public NumericValueHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public NumericValueHashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(long value) {
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        Entry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (NumericValueHashMap.eq(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public long get(Object key) {
        return this.get(key, 0L);
    }

    public long get(Object key, long def) {
        Entry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (NumericValueHashMap.eq(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return def;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.key.hashCode() & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public long put(Object key, long value) {
        if (key == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (NumericValueHashMap.eq(e.key, key)) {
                long old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        tab[index] = new Entry(key, value, tab[index]);
        ++this.count;
        return 0L;
    }

    public long remove(Object key) {
        Entry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (NumericValueHashMap.eq(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return 0L;
    }

    public void clear() {
        Object[] tab = this.table;
        Arrays.fill(tab, null);
        this.count = 0;
    }

    static class Entry {
        final Object key;
        long value;
        Entry next;

        Entry(Object key, long value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

