/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Arrays;

public final class NumericArraySet {
    private static final int[] ALPHA = new int[]{1, 1, 3, 5, 9, 19, 39, 79, 159, 317, 633, 1265, 2531, 5063, 10125, 20251, 40503, 81007, 162013, 324027, 648055, 1296111, 2592223, 5184445, 10368889, 20737779, 41475559, 82951117, 165902235, 331804471, 663608943, 1327217885};
    private int[] table;
    private int mask;
    private int alpha;
    private int size = 0;
    private int power;
    private boolean zeroStored;

    public NumericArraySet() {
        this(32);
    }

    public NumericArraySet(int size) {
        int pow = 0;
        while (1 << pow < size) {
            ++pow;
        }
        this.setPower(pow);
    }

    private void setPower(int pow) {
        this.power = pow;
        this.table = new int[1 << this.power];
        this.mask = this.table.length - 1;
        this.alpha = ALPHA[this.power];
    }

    private int firstBucket(int key) {
        return (key & this.mask ^ key >> 32 - this.power) & this.mask;
    }

    private int nextBucket(int bucket) {
        return bucket + this.alpha & this.mask;
    }

    public void clear() {
        Arrays.fill(this.table, 0);
        this.zeroStored = false;
        this.size = 0;
    }

    public int size() {
        return this.size + (this.zeroStored ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(int value) {
        if (value == 0) {
            boolean hasZero = this.zeroStored;
            this.zeroStored = true;
            return !hasZero;
        }
        if (this.size >= this.table.length * 3 / 4) {
            int[] oldTable = this.table;
            this.setPower(this.power + 1);
            this.size = 0;
            for (int i = 0; i < oldTable.length; ++i) {
                int o = oldTable[i];
                if (o == 0) continue;
                this.add(o);
            }
        }
        int i = this.firstBucket(value);
        while (true) {
            int o;
            if ((o = this.table[i]) == 0) {
                ++this.size;
                this.table[i] = value;
                return true;
            }
            if (o == value) {
                return false;
            }
            i = this.nextBucket(i);
        }
    }

    public boolean contains(int value) {
        if (value == 0) {
            return this.zeroStored;
        }
        int i = this.firstBucket(value);
        int o = this.table[i];
        while (o != 0 && value != o) {
            i = this.nextBucket(i);
            o = this.table[i];
        }
        return o != 0;
    }

    public boolean remove(int value) {
        if (value == 0) {
            boolean foundIt = this.zeroStored;
            this.zeroStored = false;
            return foundIt;
        }
        int i = this.firstBucket(value);
        int o = this.table[i];
        while (o != 0 && value != o) {
            i = this.nextBucket(i);
            o = this.table[i];
        }
        if (o == 0) {
            return false;
        }
        this.table[i] = 0;
        --this.size;
        int ti;
        while ((ti = this.table[i = this.nextBucket(i)]) != 0) {
            this.table[i] = 0;
            --this.size;
            this.add(ti);
        }
        return true;
    }

    public String toString() {
        return "size=" + this.size() + " buckets=" + this.table.length;
    }
}

