/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MatchMap
extends AbstractMap {
    private static final int FREE_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private Entry[] data = new Entry[64];
    private int[] base = new int[64];
    private int[] firstInput = new int[64];
    private int[] check = new int[64];
    private int[] next = new int[64];
    private int[] nextInput = new int[64];
    private int freeList = 0;
    private int size;
    private final boolean ignoreCase;

    public MatchMap() {
        this(false);
    }

    public MatchMap(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        for (int i = this.base.length - 2; i > 1; --i) {
            this.base[i] = i + 1;
        }
        this.freeList = 2;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public Object clone() {
        MatchMap clone = new MatchMap(this.ignoreCase);
        clone.data = new Entry[this.data.length];
        System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
        clone.base = MatchMap.clone(this.base);
        clone.firstInput = MatchMap.clone(this.firstInput);
        clone.check = MatchMap.clone(this.check);
        clone.next = MatchMap.clone(this.next);
        clone.nextInput = MatchMap.clone(this.nextInput);
        clone.freeList = this.freeList;
        clone.size = this.size;
        return clone;
    }

    private static int[] clone(int[] a) {
        int[] clone = new int[a.length];
        System.arraycopy(a, 0, clone, 0, a.length);
        return clone;
    }

    public Map.Entry match(String cs) {
        int s = 1;
        Entry match = this.data[s];
        int i = 0;
        int bound = this.check.length;
        if (this.ignoreCase) {
            int ii;
            for (int remaining = cs.length(); remaining > 0 && (ii = this.base[s] + Character.toUpperCase(cs.charAt(i))) < bound && this.check[ii] == s; --remaining) {
                s = this.next[ii];
                Entry e = this.data[s];
                if (e != null) {
                    match = e;
                }
                ++i;
            }
        } else {
            int ii;
            for (int remaining = cs.length(); remaining > 0 && (ii = this.base[s] + cs.charAt(i)) < bound && this.check[ii] == s; --remaining) {
                s = this.next[ii];
                Entry e = this.data[s];
                if (e != null) {
                    match = e;
                }
                ++i;
            }
        }
        return match;
    }

    public Object get(char[] key, int i, int remaining) {
        int s = 1;
        int bound = this.check.length;
        while (remaining > 0) {
            int ii = this.base[s] + key[i];
            if (ii >= bound || this.check[ii] != s) {
                return null;
            }
            s = this.next[ii];
            ++i;
            --remaining;
        }
        Entry e = this.data[s];
        return e == null ? null : e.value;
    }

    public Object get(String key) {
        return this.get(key.toCharArray(), 0, key.length());
    }

    @Override
    public Entry put(CharSequence cs, Object value) {
        int state = 1;
        for (int i = 0; i < cs.length(); ++i) {
            int ii;
            int checkState;
            char c = cs.charAt(i);
            if (this.ignoreCase) {
                c = Character.toUpperCase(c);
            }
            if ((checkState = this.safeCheck(ii = this.base[state] + c)) == state) {
                state = this.next[ii];
                continue;
            }
            if (checkState != 0) {
                this.rebase(state, c);
                ii = this.base[state] + c;
            }
            this.check[ii] = state;
            this.nextInput[ii] = this.firstInput[state];
            this.firstInput[state] = c;
            this.next[ii] = state = this.newState();
        }
        Entry oldEntry = this.data[state];
        this.data[state] = new Entry(cs, value);
        if (oldEntry == null) {
            ++this.size;
        }
        return oldEntry;
    }

    public Object remove(CharSequence cs) {
        int len = cs.length();
        int[] visted = new int[len];
        int state = 1;
        for (int i = 0; i < len; ++i) {
            int ii;
            visted[i] = state;
            char c = cs.charAt(i);
            if (this.ignoreCase) {
                c = Character.toUpperCase(c);
            }
            if ((ii = this.base[state] + c) >= this.check.length || this.check[ii] != state) {
                return null;
            }
            state = this.next[ii];
        }
        Entry e = this.data[state];
        if (e != null) {
            --this.size;
            this.data[state] = null;
        }
        for (int i = len - 1; i >= 0 && this.isLeaf(state) && this.data[state] == null; --i) {
            int fromState = visted[i];
            this.freeState(fromState, cs.charAt(i), state);
            state = fromState;
        }
        return e == null ? null : e.value;
    }

    @Override
    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public int size() {
                return MatchMap.this.size;
            }

            @Override
            public Iterator iterator() {
                return new EntryIterator();
            }
        };
    }

    private int safeCheck(int ii) {
        if (ii >= this.check.length) {
            this.check = MatchMap.grow(this.check, 2 * ii);
            this.next = MatchMap.grow(this.next, 2 * ii);
            this.nextInput = MatchMap.grow(this.nextInput, 2 * ii);
        }
        return this.check[ii];
    }

    private static int[] grow(int[] a, int l) {
        int[] b = new int[l];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    private static Entry[] grow(Entry[] a, int l) {
        Entry[] b = new Entry[l];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    private void rebase(int state, char c) {
        int oldB = this.base[state];
        int fi = this.firstInput[state];
        int b = 0;
        while (!this.isFree(b, oldB, fi, c)) {
            ++b;
        }
        this.base[state] = b;
        int ii = fi;
        while (ii != 0) {
            this.check[b + ii] = state;
            this.next[b + ii] = this.next[oldB + ii];
            this.nextInput[b + ii] = this.nextInput[oldB + ii];
            this.check[oldB + ii] = 0;
            ii = this.nextInput[oldB + ii];
        }
    }

    private boolean isFree(int base, int oldBase, int firstInput, char newInput) {
        if (this.safeCheck(base + newInput) != 0) {
            return false;
        }
        int c = firstInput;
        while (c != 0) {
            if (this.safeCheck(base + c) != 0) {
                return false;
            }
            c = this.nextInput[oldBase + c];
        }
        return true;
    }

    private int newState() {
        if (this.freeList == 0) {
            int ol = this.base.length;
            int nl = 2 * ol;
            this.base = MatchMap.grow(this.base, nl);
            this.data = MatchMap.grow(this.data, nl);
            this.firstInput = MatchMap.grow(this.firstInput, nl);
            for (int i = nl - 2; i > ol; --i) {
                this.base[i] = i + 1;
            }
            this.freeList = ol + 1;
            return ol;
        }
        int result = this.freeList;
        this.freeList = this.base[this.freeList];
        this.base[result] = 0;
        this.firstInput[result] = 0;
        return result;
    }

    void freeState(int fromState, char input, int toState) {
        this.base[toState] = this.freeList;
        this.freeList = toState;
        int b = this.base[fromState];
        this.check[b + input] = 0;
        int i = this.firstInput[fromState];
        if (i == input) {
            this.firstInput[fromState] = this.nextInput[b + i];
            return;
        }
        while (true) {
            int j;
            if ((j = this.nextInput[b + i]) == input) {
                this.nextInput[b + i] = this.nextInput[b + j];
                return;
            }
            i = j;
        }
    }

    private boolean isLeaf(int state) {
        return this.firstInput[state] == 0;
    }

    public static class Test {
        public static void main(String[] args) throws Exception {
            String s;
            String DICT = args.length > 0 ? args[0] : "c:/emacs-20.3.1/ispell4/ispell.words";
            MatchMap mm = new MatchMap();
            DataInputStream dis = new DataInputStream(new FileInputStream(DICT));
            for (int i = 0; i < 2000; ++i) {
                String s2 = dis.readLine();
                mm.put(s2, s2);
            }
            dis.close();
            dis = new DataInputStream(new FileInputStream(DICT));
            long start = System.currentTimeMillis();
            int count = 0;
            while ((s = dis.readLine()) != null) {
                for (int i = 10000; i > 0; --i) {
                    mm.match(s);
                    ++count;
                }
            }
            long time = System.currentTimeMillis() - start;
            System.out.println(count + " in " + time + "ms = " + ((long)count + time / 2L) / time + "K/s");
        }
    }

    static final class Entry
    implements Map.Entry {
        private final CharSequence key;
        private final Object value;

        Entry(CharSequence key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public Object setValue(Object v) {
            throw new UnsupportedOperationException();
        }
    }

    class EntryIterator
    implements Iterator {
        private int index;

        EntryIterator() {
            int i;
            for (i = MatchMap.this.data.length - 1; i >= 0 && MatchMap.this.data[i] == null; --i) {
            }
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        public Object next() {
            Entry e = MatchMap.this.data[this.index--];
            while (this.index >= 0 && MatchMap.this.data[this.index] == null) {
                --this.index;
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

