/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCacheHashMap<K, V>
extends LinkedHashMap<K, V> {
    private int maxEntries;

    public LRUCacheHashMap(int maxCapacity) {
        super((maxCapacity + 1) / 2, 2.0f, true);
        this.maxEntries = maxCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxEntries;
    }

    public void setCacheSize(int size) {
        this.maxEntries = size;
    }
}

