/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import weblogic.utils.collections.HashtableEntry;

class HashtableEnumerator
implements Enumeration {
    boolean keys;
    int index;
    HashtableEntry[] table;
    HashtableEntry entry;

    HashtableEnumerator(HashtableEntry[] table, boolean keys) {
        this.table = table;
        this.keys = keys;
        this.index = table.length;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.entry != null) {
            return true;
        }
        while (this.index-- > 0) {
            this.entry = this.table[this.index];
            if (this.entry == null) continue;
            return true;
        }
        return false;
    }

    public Object nextElement() {
        if (this.entry == null) {
            while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
            }
        }
        if (this.entry != null) {
            HashtableEntry e = this.entry;
            this.entry = e.next;
            return this.keys ? new Long(e.key) : e.value;
        }
        throw new NoSuchElementException("HashtableEnumerator");
    }
}

