/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import weblogic.utils.collections.EmbeddedListElement;
import weblogic.utils.collections.EmbeddedListIterator;

public final class EmbeddedList
extends AbstractList<EmbeddedListElement> {
    protected int size;
    protected EmbeddedListElement first;
    protected EmbeddedListElement last;

    @Override
    public void add(int index, EmbeddedListElement o) {
        this.internalAdd(index, o);
    }

    @Override
    public boolean add(EmbeddedListElement o) {
        return this.internalAdd(this.size, o);
    }

    private boolean internalAdd(int index, EmbeddedListElement element) {
        if (element.getList() != null) {
            if (element.getList().equals(this)) {
                return false;
            }
            throw new IllegalArgumentException();
        }
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        EmbeddedListElement insertAfterMe = null;
        if (index > 0) {
            insertAfterMe = this.checkedGet(index - 1);
        }
        ++this.size;
        element.setList(this);
        element.setPrev(insertAfterMe);
        EmbeddedListElement nextNext = null;
        if (insertAfterMe == null) {
            if (this.first != null) {
                nextNext = this.first;
            }
            this.first = element;
        } else {
            nextNext = insertAfterMe.getNext();
            insertAfterMe.setNext(element);
        }
        if (nextNext == null) {
            this.last = element;
            element.setNext(null);
        } else {
            element.setNext(nextNext);
            nextNext.setPrev(element);
        }
        return true;
    }

    public void moveToEnd(EmbeddedList list) {
        if (list == this) {
            throw new IllegalArgumentException();
        }
        if (list.isEmpty()) {
            return;
        }
        if (this.first == null) {
            this.first = list.first;
        } else {
            this.last.setNext(list.first);
            list.first.setPrev(this.last);
        }
        this.last = list.last;
        this.size += list.size;
        for (EmbeddedListElement element = list.first; element != null; element = element.getNext()) {
            element.setList(this);
        }
        list.last = null;
        list.first = null;
        list.size = 0;
    }

    @Override
    public void clear() {
        while (this.first != null) {
            this.remove(this.first);
        }
    }

    @Override
    public boolean contains(Object o) {
        return ((EmbeddedListElement)o).getList() == this;
    }

    @Override
    public EmbeddedListElement get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.checkedGet(index);
    }

    private EmbeddedListElement checkedGet(int index) {
        int split = this.size / 2;
        if (index < split) {
            EmbeddedListElement retVal = this.first;
            for (int lcv = 0; lcv < index; ++lcv) {
                retVal = retVal.getNext();
            }
            return retVal;
        }
        int count = this.size - index - 1;
        EmbeddedListElement retVal = this.last;
        for (int lcv = 0; lcv < count; ++lcv) {
            retVal = retVal.getPrev();
        }
        return retVal;
    }

    public EmbeddedListElement first() {
        return this.first;
    }

    public EmbeddedListElement last() {
        return this.last;
    }

    @Override
    public boolean remove(Object o) {
        EmbeddedListElement element = (EmbeddedListElement)o;
        if (!this.contains(element)) {
            return false;
        }
        if (element.getNext() != null) {
            element.getNext().setPrev(element.getPrev());
        } else {
            this.last = element.getPrev();
        }
        if (element.getPrev() == null) {
            this.first = element.getNext();
        } else {
            element.getPrev().setNext(element.getNext());
        }
        element.setList(null);
        element.setPrev(null);
        element.setNext(null);
        --this.size;
        return true;
    }

    @Override
    public EmbeddedListElement remove(int index) {
        EmbeddedListElement removeMe = this.get(index);
        this.remove(removeMe);
        return removeMe;
    }

    @Override
    public EmbeddedListElement set(int index, EmbeddedListElement element) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (element.getList() != null) {
            throw new IllegalArgumentException();
        }
        EmbeddedListElement replaceMe = this.get(index);
        element.setPrev(replaceMe.getPrev());
        element.setNext(replaceMe.getNext());
        element.setList(this);
        replaceMe.setPrev(null);
        replaceMe.setNext(null);
        replaceMe.setList(null);
        if (element.getPrev() == null) {
            this.first = element;
        } else {
            element.getPrev().setNext(element);
        }
        if (element.getNext() == null) {
            this.last = element;
        } else {
            element.getNext().setPrev(element);
        }
        return replaceMe;
    }

    public EmbeddedList split(EmbeddedListElement element, boolean after) {
        if (!this.contains(element)) {
            throw new NoSuchElementException();
        }
        EmbeddedList list = new EmbeddedList();
        if (after) {
            if (element == this.last) {
                return list;
            }
            list.first = element.getNext();
            list.last = this.last;
            this.last = element;
            list.first.setPrev(null);
            this.last.setNext(null);
        } else {
            list.first = element;
            list.last = this.last;
            if (element == this.first) {
                this.last = null;
                this.first = null;
            } else {
                this.last = element.getPrev();
                this.last.setNext(null);
                element.setPrev(null);
            }
        }
        element = list.first;
        while (element != null) {
            element.setList(list);
            element = element.getNext();
            ++list.size;
            --this.size;
        }
        return list;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public ListIterator<EmbeddedListElement> iterator(EmbeddedListElement element) {
        return new Itr(element);
    }

    @Override
    public Iterator<EmbeddedListElement> iterator() {
        return new Itr(this.first);
    }

    @Override
    public ListIterator<EmbeddedListElement> listIterator() {
        return new Itr(this.first);
    }

    @Override
    public ListIterator<EmbeddedListElement> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        if (index == this.size()) {
            return new Itr(null);
        }
        return new Itr(this.get(index));
    }

    public EmbeddedListIterator embeddedListIterator() {
        return new Itr(this.first);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] array = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        int inc = 0;
        EmbeddedListElement elt = this.first;
        while (elt != null) {
            array[inc] = elt;
            elt = elt.getNext();
            ++inc;
        }
        return array;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public List<EmbeddedListElement> subList(int fromIndex, int toIndex) {
        return new EmbeddedListSubList(this, fromIndex, toIndex - fromIndex);
    }

    private final class Itr
    implements EmbeddedListIterator {
        private EmbeddedListElement cursor;
        private EmbeddedListElement element;

        Itr(EmbeddedListElement element) {
            this.reset(element);
        }

        @Override
        public void reset(EmbeddedListElement element) {
            if (element != null && !EmbeddedList.this.contains(element)) {
                throw new IllegalArgumentException("List does not contain the specified element");
            }
            this.cursor = element;
            this.element = null;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public boolean hasPrevious() {
            if (this.cursor == null) {
                return EmbeddedList.this.last != null;
            }
            return this.cursor.getPrev() != null;
        }

        @Override
        public EmbeddedListElement next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.element = this.cursor;
            this.cursor = this.cursor.getNext();
            return this.element;
        }

        public EmbeddedListElement previous() {
            if (this.cursor != null) {
                EmbeddedListElement prev = this.cursor.getPrev();
                if (prev != null) {
                    this.element = prev;
                    this.cursor = prev;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            if (EmbeddedList.this.last != null) {
                this.element = EmbeddedList.this.last;
                this.cursor = EmbeddedList.this.last;
                return this.element;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.element == null) {
                throw new IllegalStateException();
            }
            if (this.element == this.cursor) {
                this.cursor = this.cursor.getNext();
            }
            EmbeddedList.this.remove(this.element);
            this.element = null;
        }

        public void set(Object o) {
            if (this.element == null) {
                throw new IllegalStateException();
            }
            EmbeddedListElement newVal = (EmbeddedListElement)o;
            this.remove();
            this.add(newVal);
            if (this.cursor == this.element) {
                this.cursor = newVal;
            }
            this.element = newVal;
        }

        public void add(Object o) {
            EmbeddedListElement temp = (EmbeddedListElement)o;
            if (temp.getList() != null) {
                throw new IllegalArgumentException();
            }
            if (this.cursor != null) {
                temp.setNext(this.cursor);
                temp.setPrev(this.cursor.getPrev());
                this.cursor.setPrev(temp);
            } else {
                temp.setNext(null);
                temp.setPrev(EmbeddedList.this.last);
                EmbeddedList.this.last = temp;
            }
            if (temp.getPrev() == null) {
                EmbeddedList.this.first = temp;
            } else {
                temp.getPrev().setNext(temp);
            }
            this.element = null;
            temp.setList(EmbeddedList.this);
            ++EmbeddedList.this.size;
        }

        @Override
        public int nextIndex() {
            if (this.cursor == null) {
                return EmbeddedList.this.size;
            }
            int index = 0;
            for (EmbeddedListElement temp = this.cursor.getPrev(); temp != null; temp = temp.getPrev()) {
                ++index;
            }
            return index;
        }

        @Override
        public int previousIndex() {
            if (this.cursor == null) {
                return EmbeddedList.this.size - 1;
            }
            EmbeddedListElement temp = this.cursor.getPrev();
            int index = -1;
            while (temp != null) {
                temp = temp.getPrev();
                ++index;
            }
            return index;
        }
    }

    private static class EmbeddedListSubList
    extends AbstractList<EmbeddedListElement> {
        private EmbeddedList parent;
        private final int offset;
        private int localSize;

        private EmbeddedListSubList(EmbeddedList paramParent, int paramOffset, int paramLocalSize) {
            this.parent = paramParent;
            this.offset = paramOffset;
            this.localSize = paramLocalSize;
        }

        @Override
        public EmbeddedListElement get(int index) {
            return this.parent.get(index + this.offset);
        }

        @Override
        public int size() {
            return this.localSize;
        }

        @Override
        public boolean add(EmbeddedListElement element) {
            if (element.getList() != null) {
                if (element.getList().equals(this.parent)) {
                    return false;
                }
                throw new IllegalArgumentException();
            }
            this.parent.add(this.offset + this.localSize, element);
            ++this.localSize;
            return true;
        }

        @Override
        public void add(int index, EmbeddedListElement element) {
            if (index < 0 || index > this.localSize) {
                throw new IndexOutOfBoundsException();
            }
            this.parent.add(index + this.offset, element);
            ++this.localSize;
        }

        @Override
        public EmbeddedListElement set(int index, EmbeddedListElement element) {
            if (index < 0 || index >= this.localSize) {
                throw new IndexOutOfBoundsException();
            }
            return this.parent.set(index + this.offset, element);
        }

        @Override
        public EmbeddedListElement remove(int index) {
            if (index < 0 || index >= this.localSize) {
                throw new IndexOutOfBoundsException();
            }
            --this.localSize;
            return this.parent.remove(index + this.offset);
        }
    }
}

