/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class DoubleArrayTrieMatchMap {
    private static final char TERMINATING_CHAR = '\u0000';
    private static final int FREE_STATE = 0;
    private static final int START_STATE = 1;
    private static final int NEXT_STATE = 2;
    private static final int NO_INPUT = -1;
    private static final boolean DEBUG = false;
    private Entry[] data;
    private int[] base;
    private int[] check;
    private int[] firstInput;
    private int[] nextInput;
    private int size;
    private int nextEntry;
    private boolean ignoreCase;

    private DoubleArrayTrieMatchMap() {
        this(false);
    }

    public DoubleArrayTrieMatchMap(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.data = new Entry[64];
        this.base = new int[256];
        this.check = new int[256];
        this.firstInput = new int[256];
        this.nextInput = new int[256];
        this.base[1] = 1;
        for (int i = 0; i < this.firstInput.length; ++i) {
            this.firstInput[i] = -1;
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Object clone() {
        DoubleArrayTrieMatchMap clone = new DoubleArrayTrieMatchMap();
        clone.ignoreCase = this.ignoreCase;
        clone.data = new Entry[this.data.length];
        System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
        clone.base = DoubleArrayTrieMatchMap.clone(this.base);
        clone.check = DoubleArrayTrieMatchMap.clone(this.check);
        clone.firstInput = DoubleArrayTrieMatchMap.clone(this.firstInput);
        clone.nextInput = DoubleArrayTrieMatchMap.clone(this.nextInput);
        clone.size = this.size;
        clone.nextEntry = this.nextEntry;
        return clone;
    }

    private static int[] clone(int[] a) {
        int[] clone = new int[a.length];
        System.arraycopy(a, 0, clone, 0, a.length);
        return clone;
    }

    public Map.Entry match(CharSequence key) {
        Entry e;
        int bVal;
        if (key.equals("")) {
            return this.data[0];
        }
        int len = key.length();
        int state = 1;
        Entry match = null;
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                int nextState;
                bVal = this.base[state];
                if (bVal < 0) {
                    Entry e2 = this.data[-bVal];
                    if (e2.tailMatches(key)) {
                        match = e2;
                    }
                    return match;
                }
                if (this.check[bVal] == state) {
                    match = this.data[-this.base[bVal]];
                }
                if ((nextState = bVal + Character.toUpperCase(key.charAt(i))) >= this.check.length || this.check[nextState] != state) {
                    return match;
                }
                state = nextState;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                int nextState;
                bVal = this.base[state];
                if (bVal < 0) {
                    Entry e3 = this.data[-bVal];
                    if (e3.tailMatches(key)) {
                        match = e3;
                    }
                    return match;
                }
                if (this.check[bVal] == state) {
                    match = this.data[-this.base[bVal]];
                }
                if ((nextState = bVal + key.charAt(i)) >= this.check.length || this.check[nextState] != state) {
                    return match;
                }
                state = nextState;
            }
        }
        if ((bVal = this.base[state]) < 0) {
            Entry e4 = this.data[-bVal];
            if (e4.tailMatches(key)) {
                match = e4;
            }
        } else if (this.check[bVal] == state && (e = this.data[-this.base[bVal]]).tailMatches(key)) {
            match = e;
        }
        return match;
    }

    public Object get(CharSequence key) {
        Entry e;
        int bVal;
        if (key.equals("")) {
            Object ret = this.data[0] == null ? null : this.data[0].getValue();
            return ret;
        }
        int len = key.length();
        int state = 1;
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                bVal = this.base[state];
                if (bVal < 0) {
                    Entry e2 = this.data[-bVal];
                    if (e2.tailEquals(key)) {
                        return e2.getValue();
                    }
                    return null;
                }
                int nextState = bVal + Character.toUpperCase(key.charAt(i));
                if (nextState >= this.check.length || this.check[nextState] != state) {
                    return null;
                }
                state = nextState;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                bVal = this.base[state];
                if (bVal < 0) {
                    Entry e3 = this.data[-bVal];
                    if (e3.tailEquals(key)) {
                        return e3.getValue();
                    }
                    return null;
                }
                int nextState = bVal + key.charAt(i);
                if (nextState >= this.check.length || this.check[nextState] != state) {
                    return null;
                }
                state = nextState;
            }
        }
        if ((bVal = this.base[state]) < 0) {
            e = this.data[-bVal];
        } else if (this.check[bVal] == state) {
            e = this.data[-this.base[bVal]];
        } else {
            return null;
        }
        if (e.tailEquals(key)) {
            return e.getValue();
        }
        return null;
    }

    public Object put(CharSequence cs, Object value) {
        int pos;
        char chTail;
        int nextState;
        char c;
        int bVal;
        if (cs.equals("")) {
            Object ret = this.data[0] == null ? null : this.data[0].getValue();
            this.data[0] = new Entry(cs, 0, value, this.ignoreCase);
            return ret;
        }
        int state = 1;
        int i = 0;
        while ((bVal = this.base[state]) >= 0) {
            if (i == cs.length()) {
                c = '\u0000';
            } else {
                c = cs.charAt(i++);
                if (this.ignoreCase) {
                    c = Character.toUpperCase(c);
                }
            }
            nextState = bVal + c;
            int m = this.safeCheck(nextState);
            if (m != state) {
                if (m != 0) {
                    int nextInputsFromS;
                    int nextInputsFromM = this.getAllNextInputsCount(this.base[m], this.firstInput[m]);
                    state = nextInputsFromM < (nextInputsFromS = this.getAllNextInputsCount(bVal, this.firstInput[state])) + 1 ? this.rebase(state, m, -1) : this.rebase(state, state, c);
                    nextState = this.base[state] + c;
                }
                this.insertTail(new Entry(cs, i, value, this.ignoreCase), state, nextState, c);
                return null;
            }
            state = nextState;
        }
        Entry e = this.data[-bVal];
        if (e.tailEquals(cs)) {
            this.data[-bVal] = new Entry(cs, i, value, this.ignoreCase);
            return e.getValue();
        }
        while (true) {
            chTail = e.incrementTailIndex();
            if (this.ignoreCase) {
                chTail = Character.toUpperCase(chTail);
            }
            if (i < cs.length()) {
                c = cs.charAt(i++);
                if (this.ignoreCase) {
                    c = Character.toUpperCase(c);
                }
            } else {
                c = '\u0000';
            }
            if (chTail != c) break;
            this.base[state] = pos = this.xCheck(c);
            nextState = pos + c;
            this.check[nextState] = state;
            this.writeFirstAndNextInput(state, nextState, c);
            state = nextState;
        }
        this.base[state] = pos = this.xCheck(chTail, c);
        nextState = pos + chTail;
        this.base[nextState] = bVal;
        this.check[nextState] = state;
        this.writeFirstAndNextInput(state, nextState, chTail);
        nextState = pos + c;
        this.insertTail(new Entry(cs, i, value, this.ignoreCase), state, nextState, c);
        return null;
    }

    public Object remove(CharSequence key) {
        Entry e;
        int bVal;
        int i;
        if (key.equals("")) {
            Object ret = this.data[0] == null ? null : this.data[0].getValue();
            this.data[0] = null;
            return ret;
        }
        int state = 1;
        int len = key.length();
        int[] visited = new int[len + 1];
        char c = '\u0000';
        for (i = 0; i < len; ++i) {
            int nextState;
            bVal = this.base[state];
            if (bVal < 0) {
                Entry e2 = this.data[-bVal];
                if (!e2.tailEquals(key)) {
                    return null;
                }
                --this.size;
                this.data[-bVal] = null;
                this.freeState(key, visited, --i, state, c);
                return e2.getValue();
            }
            c = key.charAt(i);
            if (this.ignoreCase) {
                c = Character.toUpperCase(c);
            }
            if ((nextState = bVal + c) >= this.check.length || this.check[nextState] != state) {
                return null;
            }
            visited[i] = state;
            state = nextState;
        }
        bVal = this.base[state];
        if (bVal > 0) {
            if (this.check[bVal] == state) {
                visited[i++] = state;
                state = bVal;
                bVal = this.base[bVal];
                c = '\u0000';
            } else {
                return null;
            }
        }
        if (!(e = this.data[-bVal]).tailEquals(key)) {
            return null;
        }
        --this.size;
        this.data[-bVal] = null;
        this.freeState(key, visited, --i, state, c);
        return e.getValue();
    }

    private void freeState(CharSequence key, int[] visited, int pos, int state, char c) {
        while (this.isLeaf(state)) {
            this.base[state] = 0;
            this.check[state] = 0;
            int fromState = visited[pos];
            int b = this.base[fromState];
            int fi = this.firstInput[fromState];
            if (fi == c) {
                this.firstInput[fromState] = this.nextInput[b + fi];
                this.nextInput[b + fi] = 0;
            } else {
                while (true) {
                    int j;
                    if ((j = this.nextInput[b + fi]) == c) {
                        this.nextInput[b + fi] = this.nextInput[b + j];
                        this.nextInput[b + j] = 0;
                        break;
                    }
                    fi = j;
                }
            }
            state = fromState;
            if (pos == 0) break;
            c = key.charAt(--pos);
            if (!this.ignoreCase) continue;
            c = Character.toUpperCase(c);
        }
    }

    private boolean isLeaf(int state) {
        return this.firstInput[state] == -1;
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public int size() {
                if (DoubleArrayTrieMatchMap.this.data[0] == null) {
                    return DoubleArrayTrieMatchMap.this.size;
                }
                return DoubleArrayTrieMatchMap.this.size + 1;
            }

            @Override
            public Iterator iterator() {
                return new EntryIterator();
            }
        };
    }

    private void insertTail(Entry e, int currentState, int finalState, char c) {
        if (this.nextEntry == this.data.length - 1) {
            this.data = DoubleArrayTrieMatchMap.grow(this.data);
        }
        this.data[++this.nextEntry] = e;
        ++this.size;
        this.safeCheck(finalState);
        this.base[finalState] = -this.nextEntry;
        this.check[finalState] = currentState;
        this.writeFirstAndNextInput(currentState, finalState, c);
    }

    private int rebase(int current, int s, int c) {
        int newBaseVal;
        int oldBaseVal = this.base[s];
        this.base[s] = newBaseVal = this.xCheck(oldBaseVal, this.firstInput[s], c);
        int ch = this.firstInput[s];
        while (ch != -1) {
            int oldB;
            int oldNode = oldBaseVal + ch;
            int newNode = newBaseVal + ch;
            this.base[newNode] = oldB = this.base[oldNode];
            this.check[newNode] = this.check[oldNode];
            this.firstInput[newNode] = this.firstInput[oldNode];
            this.nextInput[newNode] = this.nextInput[oldNode];
            if (current != s && oldNode == current) {
                current = newNode;
            }
            int p = this.firstInput[oldNode];
            while (p != -1) {
                this.check[oldB + p] = newNode;
                p = this.nextInput[oldB + p];
            }
            this.base[oldNode] = 0;
            this.check[oldNode] = 0;
            this.firstInput[oldNode] = -1;
            ch = this.nextInput[oldBaseVal + ch];
        }
        return current;
    }

    private int getAllNextInputsCount(int base, int fi) {
        int i = 0;
        int ch = fi;
        while (ch != -1) {
            ++i;
            ch = this.nextInput[base + ch];
        }
        return i;
    }

    private int xCheck(char chTail) {
        int b1 = 2;
        while (this.safeCheck(b1 + chTail) != 0) {
            ++b1;
        }
        return b1;
    }

    private int xCheck(char chTail, char c) {
        int b1 = 2;
        int b = 0;
        while (b != b1) {
            b = b1;
            while (this.safeCheck(b1 + chTail) != 0) {
                ++b1;
            }
            while (this.safeCheck(b1 + c) != 0) {
                ++b1;
            }
        }
        return b;
    }

    private int xCheck(int baseVal, int fi, int c) {
        int b1 = 2;
        int b = 0;
        while (b != b1) {
            b = b1;
            if (c != -1) {
                while (this.safeCheck(b1 + c) != 0) {
                    ++b1;
                }
            }
            int i = fi;
            while (i != -1) {
                while (this.safeCheck(b1 + i) != 0) {
                    ++b1;
                }
                i = this.nextInput[baseVal + i];
            }
        }
        int j = fi;
        while (j != -1) {
            j = this.nextInput[baseVal + j];
        }
        return b;
    }

    private void writeFirstAndNextInput(int firstPos, int nextPos, char c) {
        this.nextInput[nextPos] = this.firstInput[firstPos];
        this.firstInput[firstPos] = c;
    }

    private int safeCheck(int index) {
        if (index >= this.check.length) {
            this.base = DoubleArrayTrieMatchMap.grow(this.base, index * 2);
            this.check = DoubleArrayTrieMatchMap.grow(this.check, index * 2);
            this.firstInput = DoubleArrayTrieMatchMap.growAndInitialize(this.firstInput, index * 2, -1);
            this.nextInput = DoubleArrayTrieMatchMap.grow(this.nextInput, index * 2);
        }
        return this.check[index];
    }

    private static int[] grow(int[] a, int size) {
        int[] b = new int[size];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    private static int[] growAndInitialize(int[] a, int size, int initialVal) {
        int oldLen = a.length;
        int[] b = DoubleArrayTrieMatchMap.grow(a, size);
        for (int i = oldLen; i < size; ++i) {
            b[i] = initialVal;
        }
        return b;
    }

    private static Entry[] grow(Entry[] data) {
        Entry[] ret = new Entry[data.length * 2];
        System.arraycopy(data, 0, ret, 0, data.length);
        return ret;
    }

    private static void p(String s) {
    }

    private void dump(String msg) {
        DoubleArrayTrieMatchMap.p("<DUMPING BEGIN> : " + msg);
        DoubleArrayTrieMatchMap.printArray("BASE", this.base);
        DoubleArrayTrieMatchMap.printArray("CHECK", this.check);
        DoubleArrayTrieMatchMap.printArray("FIRSTINPUT", this.firstInput);
        DoubleArrayTrieMatchMap.printArray("NEXTINPUT", this.nextInput);
        DoubleArrayTrieMatchMap.printArray("DATA", this.data);
        DoubleArrayTrieMatchMap.p("********* <DUMPING END>*************");
    }

    private static void printArray(String name, int[] data) {
        StringBuilder indexBuffer = new StringBuilder("[");
        StringBuilder valueBuffer = new StringBuilder("[");
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 0) continue;
            indexBuffer.append(i).append(", ");
            valueBuffer.append(data[i]).append(", ");
        }
        indexBuffer.append("]");
        valueBuffer.append("]");
        DoubleArrayTrieMatchMap.p("Dumping " + name);
        DoubleArrayTrieMatchMap.p(indexBuffer.toString());
        DoubleArrayTrieMatchMap.p(valueBuffer.toString());
    }

    private static void printArray(String name, Entry[] data) {
        DoubleArrayTrieMatchMap.p("Dumping " + name);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            DoubleArrayTrieMatchMap.p(i + ". " + data[i].toString());
        }
    }

    private final class EntryIterator
    implements Iterator {
        private int index;

        EntryIterator() {
            int i;
            for (i = DoubleArrayTrieMatchMap.this.data.length - 1; i >= 0 && DoubleArrayTrieMatchMap.this.data[i] == null; --i) {
            }
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        public Object next() {
            Entry e = DoubleArrayTrieMatchMap.this.data[this.index--];
            while (this.index >= 0 && DoubleArrayTrieMatchMap.this.data[this.index] == null) {
                --this.index;
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Entry
    implements Map.Entry {
        private final CharSequence key;
        private Object value;
        private int tailIndex;
        private boolean ignoreCase;

        Entry(CharSequence key, int tailIndex, Object value, boolean ignoreCase) {
            this.key = key;
            if (tailIndex > key.length()) {
                System.err.println("Got invalid tailIndex " + tailIndex + " for key " + key);
                this.tailIndex = key.length();
            } else {
                this.tailIndex = tailIndex;
            }
            this.value = value;
            this.ignoreCase = ignoreCase;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object v) {
            Object temp = this.value;
            this.value = v;
            return temp;
        }

        private CharSequence getTail() {
            if (this.tailIndex == this.key.length()) {
                return null;
            }
            return this.key.subSequence(this.tailIndex, this.key.length());
        }

        private boolean tailEquals(CharSequence other) {
            return this.key.length() == other.length() && this.tailMatches(other);
        }

        private boolean tailMatches(CharSequence other) {
            if (this.key.length() > other.length()) {
                return false;
            }
            if (this.ignoreCase) {
                for (int i = this.tailIndex; i < this.key.length(); ++i) {
                    if (Character.toUpperCase(this.key.charAt(i)) == Character.toUpperCase(other.charAt(i))) continue;
                    return false;
                }
            } else {
                for (int i = this.tailIndex; i < this.key.length(); ++i) {
                    if (this.key.charAt(i) == other.charAt(i)) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "Key: " + this.key + " Value: " + this.value + " Tail: " + (this.getTail() == null ? "<none>" : this.getTail());
        }

        private char incrementTailIndex() {
            if (this.tailIndex == this.key.length()) {
                return '\u0000';
            }
            return this.key.charAt(this.tailIndex++);
        }
    }
}

