/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.io.ReadObjectUtils;

public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private transient ConcurrentHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap();
    }

    public ConcurrentHashSet(Collection c) {
        this.map = new ConcurrentHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor) {
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor);
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            ConcurrentHashSet newSet = (ConcurrentHashSet)super.clone();
            newSet.map = (ConcurrentHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.capacity());
        s.writeFloat(this.map.loadFactor());
        s.writeInt(this.map.size());
        Iterator<E> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int capacity = s.readInt();
        float loadFactor = s.readFloat();
        ReadObjectUtils.ensureValidSize(capacity);
        this.map = new ConcurrentHashMap(capacity, loadFactor);
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.map.put(e, PRESENT);
        }
    }
}

