/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import weblogic.utils.UnsyncStringBuffer;
import weblogic.utils.io.ReadObjectUtils;

public class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry<K, V>[] table;
    private transient int size;
    private int threshold;
    private final float loadFactor;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private transient Set<K> keySet = null;
    private transient Collection<V> values = null;
    private static final long serialVersionUID = -6452706556724125778L;

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f);
    }

    public ConcurrentHashMap(Map<K, V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(m);
    }

    private static int hash(Object x) {
        if (x == null) {
            return 0;
        }
        int h = x.hashCode();
        return h - (h << 7);
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    public final int capacity() {
        return this.table.length;
    }

    public final float loadFactor() {
        return this.loadFactor;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> e = this.getEntry(key);
        return e == null ? null : (V)e.value;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    protected Entry<K, V> getEntry(Object key) {
        Object k = key;
        int hash = ConcurrentHashMap.hash(k);
        Entry<K, V>[] tab = this.table;
        Entry<K, V> e = tab[hash & tab.length - 1];
        while (e != null) {
            if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        K k = key;
        int hash = ConcurrentHashMap.hash(k);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int i = hash & this.table.length - 1;
            Entry<K, V> e = this.table[i];
            while (e != null) {
                if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                    Object oldValue = e.value;
                    e.value = value;
                    return oldValue;
                }
                e = e.next;
            }
            this.table[i] = this.createEntry(hash, k, value, this.table[i]);
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        K k = key;
        int hash = ConcurrentHashMap.hash(k);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int i = hash & this.table.length - 1;
            Entry<K, V> e = this.table[i];
            while (e != null) {
                if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                    return e.value;
                }
                e = e.next;
            }
            this.table[i] = this.createEntry(hash, k, value, this.table[i]);
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return null;
    }

    private void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        int mask = newCapacity - 1;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<K, V> e = oldTable[i];
            while (e != null) {
                Entry clone = (Entry)e.clone();
                int j = clone.hash & mask;
                clone.next = newTable[j];
                newTable[j] = clone;
                e = e.next;
            }
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    @Override
    public final synchronized void putAll(Map<? extends K, ? extends V> t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> e = this.removeEntryForKey(key);
        return e == null ? null : (V)e.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry<K, V> removeEntryForKey(Object key) {
        Object k = key;
        int hash = ConcurrentHashMap.hash(k);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int i = hash & this.table.length - 1;
            Entry<K, V> e = this.table[i];
            if (e == null) {
                return null;
            }
            if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                --this.size;
                this.table[i] = e.next;
                return e;
            }
            Entry<K, V> prev = e;
            e = e.next;
            while (e != null) {
                if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                    --this.size;
                    prev.next = e.next;
                    return e;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry<K, V> removeMapping(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object k = entry.getKey();
        int hash = ConcurrentHashMap.hash(k);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int i = hash & this.table.length - 1;
            Entry<K, V> e = this.table[i];
            if (e == null) {
                return null;
            }
            if (e.hash == hash && e.equals(entry)) {
                --this.size;
                this.table[i] = e.next;
                return e;
            }
            Entry<K, V> prev = e;
            e = e.next;
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    --this.size;
                    prev.next = e.next;
                    return e;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.table = new Entry[this.table.length];
        this.size = 0;
    }

    @Override
    public final boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public final Object clone() {
        return new ConcurrentHashMap<K, V>(this);
    }

    protected Entry<K, V> createEntry(int h, K k, V v, Entry<K, V> n) {
        return new Entry<K, V>(h, k, v, n);
    }

    public final String toPrettyString() {
        return this.toPrettyString(0);
    }

    public final String toPrettyString(int indent) {
        UnsyncStringBuffer blk = new UnsyncStringBuffer();
        for (int x = 0; x < indent; ++x) {
            blk.append("  ");
        }
        UnsyncStringBuffer sb = new UnsyncStringBuffer();
        sb.append(blk.toString() + "Size: [" + this.size() + ", " + this.entrySet().size() + "] {\n");
        Set<Map.Entry<K, V>> set = this.entrySet();
        Iterator<Map.Entry<K, V>> i = set.iterator();
        Map.Entry<K, V> entry = null;
        while (i.hasNext()) {
            entry = i.next();
            if (entry.getValue() instanceof ConcurrentHashMap) {
                sb.append(blk.toString() + "  " + entry.getKey() + "=" + ((ConcurrentHashMap)entry.getValue()).toPrettyString(indent + 1) + "\n");
                continue;
            }
            sb.append(blk.toString() + "  " + entry.getKey() + "=" + entry.getValue() + "\n");
        }
        sb.append(blk.toString() + "}\n");
        return sb.toString();
    }

    @Override
    public final Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public final Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = ReadObjectUtils.createArray(Entry.class, numBuckets);
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = ConcurrentHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentHashMap.this.removeEntryForKey(o) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        final Entry<K, V>[] table;
        Entry<K, V> next;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.table = ConcurrentHashMap.this.table;
            if (ConcurrentHashMap.this.size == 0) {
                return;
            }
            Entry<K, V>[] t = this.table;
            int i = t.length - 1;
            Entry n = t[i];
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry<K, V>[] t = this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        @Override
        public final void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.key;
            this.current = null;
            ConcurrentHashMap.this.removeEntryForKey(k);
        }
    }

    protected static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        final int hash;
        Entry<K, V> next;

        protected Entry(int h, K k, V v, Entry<K, V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        protected Object clone() {
            return new Entry<K, V>(this.hash, this.key, this.value, null);
        }
    }
}

