/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import weblogic.utils.collections.CombinedIterator;

public class CombinedSet
extends AbstractSet {
    private final Collection[] sets;

    public CombinedSet(Collection[] sets) {
        this.sets = sets;
    }

    @Override
    public int size() {
        int n = 0;
        for (int i = 0; i < this.sets.length; ++i) {
            n += this.sets[i].size();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.sets.length; ++i) {
            if (this.sets[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.sets.length; ++i) {
            if (!this.sets[i].contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        Iterator[] iterators = new Iterator[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            iterators[i] = this.sets[i].iterator();
        }
        return new CombinedIterator(iterators);
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

