/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CombinedIterator
implements Iterator {
    private final Iterator[] iterators;
    private int i = 0;

    public CombinedIterator(Iterator[] iterators) {
        this.iterators = iterators;
    }

    public CombinedIterator(Iterator i1, Iterator i2) {
        this(new Iterator[]{i1, i2});
    }

    public CombinedIterator(Collection c) {
        this(c.toArray(new Iterator[c.size()]));
    }

    @Override
    public boolean hasNext() {
        while (this.i < this.iterators.length && !this.iterators[this.i].hasNext()) {
            this.iterators[this.i++] = null;
        }
        return this.i < this.iterators.length;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterators[this.i].next();
    }

    @Override
    public void remove() {
        this.iterators[this.i].remove();
    }
}

