/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CircularQueue<E>
extends AbstractCollection<E> {
    private static final int MAX_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 256;
    private int size = 0;
    private int producerIndex = 0;
    private int consumerIndex = 0;
    private int capacity;
    private int maxCapacity;
    private int bitmask;
    private Object[] q;

    public CircularQueue() {
        this(256);
    }

    public CircularQueue(int c) {
        this(c, 0x40000000);
    }

    public CircularQueue(int c, int mc) {
        if (c > mc) {
            throw new IllegalArgumentException("Capacity greater than maximum");
        }
        if (mc > 0x40000000) {
            throw new IllegalArgumentException("Maximum capacity greater than allowed");
        }
        this.capacity = 1;
        while (this.capacity < c) {
            this.capacity <<= 1;
        }
        this.maxCapacity = 1;
        while (this.maxCapacity < mc) {
            this.maxCapacity <<= 1;
        }
        this.bitmask = this.capacity - 1;
        this.q = new Object[this.capacity];
    }

    private CircularQueue(CircularQueue<E> oldQueue) {
        this.size = oldQueue.size;
        this.producerIndex = oldQueue.producerIndex;
        this.consumerIndex = oldQueue.consumerIndex;
        this.capacity = oldQueue.capacity;
        this.maxCapacity = oldQueue.maxCapacity;
        this.bitmask = oldQueue.bitmask;
        this.q = new Object[oldQueue.q.length];
        System.arraycopy(oldQueue.q, 0, this.q, 0, this.q.length);
    }

    private boolean expandQueue() {
        if (this.capacity == this.maxCapacity) {
            return false;
        }
        int old_capacity = this.capacity;
        Object[] old_q = this.q;
        this.capacity += this.capacity;
        this.bitmask = this.capacity - 1;
        this.q = new Object[this.capacity];
        System.arraycopy(old_q, this.consumerIndex, this.q, 0, old_capacity - this.consumerIndex);
        if (this.consumerIndex != 0) {
            System.arraycopy(old_q, 0, this.q, old_capacity - this.consumerIndex, this.consumerIndex);
        }
        this.consumerIndex = 0;
        this.producerIndex = this.size;
        return true;
    }

    @Override
    public boolean add(E obj) {
        if (this.size == this.capacity && !this.expandQueue()) {
            return false;
        }
        ++this.size;
        this.q[this.producerIndex] = obj;
        this.producerIndex = this.producerIndex + 1 & this.bitmask;
        return true;
    }

    public E remove() {
        if (this.size == 0) {
            return null;
        }
        --this.size;
        Object obj = this.q[this.consumerIndex];
        this.q[this.consumerIndex] = null;
        this.consumerIndex = this.consumerIndex + 1 & this.bitmask;
        return (E)obj;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.q[this.consumerIndex];
    }

    @Override
    public void clear() {
        Arrays.fill(this.q, null);
        this.size = 0;
        this.producerIndex = 0;
        this.consumerIndex = 0;
    }

    public Object clone() {
        return new CircularQueue<E>(this);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer(super.toString() + " - capacity: '" + this.capacity() + "' size: '" + this.size() + "'");
        if (this.size > 0) {
            s.append(" elements:");
            for (int i = 0; i < this.size; ++i) {
                s.append('\n');
                s.append('\t');
                s.append(this.q[this.consumerIndex + i & this.bitmask].toString());
            }
        }
        return s.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final int ci;
            private final int pi;
            private int s;
            private int i;
            {
                this.ci = CircularQueue.this.consumerIndex;
                this.pi = CircularQueue.this.producerIndex;
                this.s = CircularQueue.this.size;
                this.i = this.ci;
            }

            @Override
            public boolean hasNext() {
                this.checkForModification();
                return this.s > 0;
            }

            @Override
            public E next() {
                this.checkForModification();
                if (this.s == 0) {
                    throw new NoSuchElementException();
                }
                --this.s;
                Object r = CircularQueue.this.q[this.i];
                this.i = this.i + 1 & CircularQueue.this.bitmask;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void checkForModification() {
                if (this.ci != CircularQueue.this.consumerIndex) {
                    throw new ConcurrentModificationException();
                }
                if (this.pi != CircularQueue.this.producerIndex) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }
}

