/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArraySet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6062756876297819410L;
    private static final Object NULL = new Object();
    private static final int[] ALPHA = new int[]{1, 1, 3, 5, 9, 19, 39, 79, 159, 317, 633, 1265, 2531, 5063, 10125, 20251, 40503, 81007, 162013, 324027, 648055, 1296111, 2592223, 5184445, 10368889, 20737779, 41475559, 82951117, 165902235, 331804471, 663608943, 1327217885};
    private Object[] table;
    private int mask;
    private int alpha;
    private int size;
    private int power;
    private int modCount;
    private final int originalSize;

    public Object clone() {
        ArraySet<E> clone = new ArraySet<E>();
        clone.table = (Object[])this.table.clone();
        clone.mask = this.mask;
        clone.alpha = this.alpha;
        clone.size = this.size;
        clone.power = this.power;
        clone.modCount = this.modCount;
        return clone;
    }

    public ArraySet() {
        this(32);
    }

    public ArraySet(int size) {
        this.originalSize = size;
        this.init();
    }

    private void init() {
        this.size = 0;
        int pow = 0;
        while (1 << pow < this.originalSize) {
            ++pow;
        }
        this.setPower(pow);
    }

    private void setPower(int pow) {
        this.power = pow;
        this.table = new Object[1 << this.power];
        this.mask = this.table.length - 1;
        this.alpha = ALPHA[this.power];
    }

    private int firstBucket(int key) {
        return (key & this.mask ^ key >> 32 - this.power) & this.mask;
    }

    private int nextBucket(int bucket) {
        return bucket + this.alpha & this.mask;
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    @Override
    public void clear() {
        this.init();
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean add(E value) {
        Object nonNullValue = value != null ? value : NULL;
        return this.internalAdd(nonNullValue);
    }

    private boolean internalAdd(Object value) {
        if (value == null) {
            value = NULL;
        }
        if (this.size >= this.table.length * 3 / 4) {
            Object[] oldTable = this.table;
            this.setPower(this.power + 1);
            this.size = 0;
            for (int i = 0; i < oldTable.length; ++i) {
                Object o = oldTable[i];
                if (o == null) continue;
                this.internalAdd(o);
            }
        }
        int i = this.firstBucket(value.hashCode());
        while (true) {
            Object o;
            if ((o = this.table[i]) == null) {
                ++this.size;
                ++this.modCount;
                this.table[i] = value;
                return true;
            }
            if (ArraySet.eq(o, value)) {
                return false;
            }
            i = this.nextBucket(i);
        }
    }

    public E get(E value) {
        Object retVal = this.internalGet(value);
        if (retVal == null) {
            return null;
        }
        if (NULL.equals(retVal)) {
            return null;
        }
        return (E)retVal;
    }

    private Object internalGet(Object value) {
        if (value == null) {
            value = NULL;
        }
        int i = this.firstBucket(value.hashCode());
        Object o = this.table[i];
        while (o != null && !ArraySet.eq(value, o)) {
            i = this.nextBucket(i);
            o = this.table[i];
        }
        return o;
    }

    @Override
    public boolean contains(Object value) {
        return this.internalGet(value) != null;
    }

    @Override
    public boolean remove(Object value) {
        if (value == null) {
            value = NULL;
        }
        int i = this.firstBucket(value.hashCode());
        Object o = this.table[i];
        while (o != null && !ArraySet.eq(value, o)) {
            i = this.nextBucket(i);
            o = this.table[i];
        }
        if (o == null) {
            return false;
        }
        this.table[i] = null;
        --this.size;
        ++this.modCount;
        Object ti;
        while ((ti = this.table[i = this.nextBucket(i)]) != null) {
            this.table[i] = null;
            --this.size;
            this.internalAdd(ti);
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final int expectedModCount;
            private int index;
            private Object next;
            {
                this.expectedModCount = ArraySet.this.modCount;
                this.index = ArraySet.this.table.length;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null && this.index > 0) {
                    this.next = ArraySet.this.table[--this.index];
                }
                return this.next != null;
            }

            @Override
            public E next() {
                if (this.expectedModCount != ArraySet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.hasNext()) {
                    Object n = this.next;
                    this.next = null;
                    if (n.equals(NULL)) {
                        return null;
                    }
                    return n;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

