/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassFinderIndex;
import weblogic.utils.classloaders.index.PackageIndices;
import weblogic.work.ExecuteThreadLite;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class BackgroundClassFinderIndex
extends ClassFinderIndex {
    private final AtomicInteger idxIteration = new AtomicInteger(0);
    private final ReadWriteLock packageIndicesLock = new ReentrantReadWriteLock();
    private volatile List<PostFreezeAddition> postFreezeAdditions = new ArrayList<PostFreezeAddition>();

    public BackgroundClassFinderIndex(List<ClassFinder> finders) {
        super(finders, new ConcurrentHashMap<String, PackageIndices>());
    }

    @Override
    public void update(ClassFinder finder, int codeSourceIndex) {
        this.index(finder, codeSourceIndex);
    }

    @Override
    public void build(Runnable onFinishOptimization) {
        this.doIndexing(onFinishOptimization);
    }

    int getIndexingIteration() {
        return this.idxIteration.get();
    }

    private void buildInternal() {
        int i;
        List<ClassFinder> finders = this.getList();
        int size = finders.size();
        while ((i = this.idxIteration.getAndIncrement()) < size) {
            ClassFinder f = finders.get(i);
            this.update(f, i);
        }
    }

    protected Runnable createIndexingRunnable(final Runnable onFinishOptimization) {
        return new Runnable(){

            @Override
            public void run() {
                BackgroundClassFinderIndex.this.buildInternal();
                if (onFinishOptimization != null) {
                    onFinishOptimization.run();
                }
            }
        };
    }

    protected WorkManager selectWorkManager() {
        WorkManager wm = null;
        Thread current = Thread.currentThread();
        if (current instanceof ExecuteThreadLite) {
            wm = ((ExecuteThreadLite)current).getWorkManager();
        }
        if (wm == null) {
            wm = WorkManagerFactory.getInstance().getSystem();
        }
        return wm;
    }

    private void doIndexing(Runnable onFinishOptimization) {
        Runnable run = this.createIndexingRunnable(onFinishOptimization);
        WorkManager wm = this.selectWorkManager();
        wm.schedule(run);
    }

    @Override
    protected void addUnindexable(int codeSourceIndex) {
        Lock lock = this.packageIndicesLock.writeLock();
        lock.lock();
        try {
            super.addUnindexable(codeSourceIndex);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int[] getUnindexable() {
        Lock lock = this.packageIndicesLock.readLock();
        lock.lock();
        try {
            int[] nArray = super.getUnindexable();
            return nArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected PackageIndices createPackageIndices() {
        return new ConcurrentPackageIndices();
    }

    @Override
    protected PackageIndices putIfAbsent(Map<String, PackageIndices> index, String packageName, PackageIndices indices) {
        return ((ConcurrentMap)index).putIfAbsent(packageName, indices);
    }

    @Override
    public Iterator<ClassFinder> iterator(String packageName) {
        List<PostFreezeAddition> pFA = this.postFreezeAdditions;
        return pFA.isEmpty() ? new PackageIndexedIterator(packageName) : new PackageIndexedPlusPostFreezeAddition(packageName, pFA);
    }

    public ConcurrentMap<String, PackageIndices> getMap() {
        return (ConcurrentMap)super.getMap();
    }

    @Override
    public boolean canPersist() {
        return true;
    }

    @Override
    public synchronized void handlePostFreezeAddition(int effectiveIndex, ClassFinder finder) {
        ArrayList<PostFreezeAddition> changed = new ArrayList<PostFreezeAddition>(this.postFreezeAdditions);
        ListIterator<PostFreezeAddition> it = changed.listIterator(changed.size());
        boolean isAdded = false;
        while (it.hasPrevious()) {
            PostFreezeAddition prev = (PostFreezeAddition)it.previous();
            if (effectiveIndex < prev.effectiveIndex) continue;
            it.add(new PostFreezeAddition(effectiveIndex, finder));
            isAdded = true;
            break;
        }
        if (!isAdded) {
            changed.add(0, new PostFreezeAddition(effectiveIndex, finder));
        }
        this.postFreezeAdditions = changed;
    }

    private static final class PostFreezeAddition {
        final int effectiveIndex;
        final ClassFinder finder;

        PostFreezeAddition(int effectiveIndex, ClassFinder finder) {
            this.effectiveIndex = effectiveIndex;
            this.finder = finder;
        }
    }

    protected class PackageIndexedPlusPostFreezeAddition
    extends PackageIndexedIterator {
        private final Iterator<PostFreezeAddition> iPostFreeze;
        private PostFreezeAddition nextPostFreeze;

        public PackageIndexedPlusPostFreezeAddition(String packageName, List<PostFreezeAddition> pFA) {
            super(packageName);
            this.iPostFreeze = pFA.iterator();
            this.nextPostFreeze = this.iPostFreeze.next();
        }

        @Override
        public boolean hasNext() {
            if (this.iterationIndex < this.iterationSize) {
                return true;
            }
            if (this.nextPostFreeze != null || this.iPostFreeze.hasNext()) {
                return true;
            }
            if (this.currentIndex >= this.indexingIndex && this.currentIndex + 1 == this.list.size()) {
                return false;
            }
            return this.indexingIndex < this.list.size();
        }

        @Override
        public ClassFinder next() {
            if (this.iterationIndex < this.iterationSize) {
                int tmp = this.its[this.iterationIndex++];
                if (this.nextPostFreeze == null && this.iPostFreeze.hasNext()) {
                    this.nextPostFreeze = this.iPostFreeze.next();
                }
                if (this.nextPostFreeze != null && tmp >= this.nextPostFreeze.effectiveIndex) {
                    this.currentIndex = this.nextPostFreeze.effectiveIndex;
                    --this.iterationIndex;
                    ClassFinder finder = this.nextPostFreeze.finder;
                    this.nextPostFreeze = null;
                    return finder;
                }
                this.currentIndex = tmp;
                return (ClassFinder)this.list.get(this.currentIndex);
            }
            if (this.indexingIndex < this.list.size()) {
                int n = this.currentIndex = this.currentIndex < this.indexingIndex ? this.indexingIndex : this.currentIndex + 1;
                if (this.currentIndex < this.list.size()) {
                    if (this.nextPostFreeze == null && this.iPostFreeze.hasNext()) {
                        this.nextPostFreeze = this.iPostFreeze.next();
                    }
                    if (this.nextPostFreeze != null && this.currentIndex >= this.nextPostFreeze.effectiveIndex) {
                        this.currentIndex = this.nextPostFreeze.effectiveIndex;
                        ClassFinder finder = this.nextPostFreeze.finder;
                        this.nextPostFreeze = null;
                        return finder;
                    }
                    return (ClassFinder)this.list.get(this.currentIndex);
                }
            }
            if (this.nextPostFreeze == null && this.iPostFreeze.hasNext()) {
                this.nextPostFreeze = this.iPostFreeze.next();
            }
            if (this.nextPostFreeze != null) {
                this.currentIndex = this.nextPostFreeze.effectiveIndex;
                ClassFinder finder = this.nextPostFreeze.finder;
                this.nextPostFreeze = null;
                return finder;
            }
            return null;
        }
    }

    protected class PackageIndexedIterator
    implements Iterator<ClassFinder> {
        private final PackageIndices iteration;
        protected final List<ClassFinder> list;
        protected final int indexingIndex;
        protected int currentIndex;
        protected final int iterationSize;
        protected final int[] its;
        protected int iterationIndex;

        public PackageIndexedIterator(String packageName) {
            PackageIndices created;
            this.list = BackgroundClassFinderIndex.this.getList();
            this.indexingIndex = BackgroundClassFinderIndex.this.idxIteration.get() - 1;
            this.currentIndex = -1;
            Map map = BackgroundClassFinderIndex.this.getMap();
            PackageIndices it = (PackageIndices)map.get(packageName);
            if (it == null && (it = map.putIfAbsent(packageName, created = BackgroundClassFinderIndex.this.createPackageIndices())) == null) {
                it = created;
            }
            it = PackageIndices.merge(it, BackgroundClassFinderIndex.this.getUnindexable());
            this.iterationSize = it.size();
            this.its = it.rawAccess();
            this.iteration = it;
            this.iterationIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.iterationIndex < this.iterationSize) {
                return true;
            }
            if (this.currentIndex >= this.indexingIndex && this.currentIndex + 1 == this.list.size()) {
                return false;
            }
            return this.indexingIndex < this.list.size();
        }

        @Override
        public ClassFinder next() {
            if (this.iterationIndex < this.iterationSize) {
                this.currentIndex = this.its[this.iterationIndex++];
                return this.list.get(this.currentIndex);
            }
            if (this.indexingIndex < this.list.size()) {
                int n = this.currentIndex = this.currentIndex < this.indexingIndex ? this.indexingIndex : this.currentIndex + 1;
                if (this.currentIndex < this.list.size()) {
                    return this.list.get(this.currentIndex);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public boolean shouldDefineCurrentPackage() {
            if (this.iteration.getPackageDefinedIndex() < 0) {
                this.iteration.setPackageDefinedIndex(this.currentIndex);
                return true;
            }
            return false;
        }
    }

    protected class ConcurrentPackageIndices
    extends PackageIndices {
        public ConcurrentPackageIndices() {
        }

        public ConcurrentPackageIndices(int firstIndex) {
            super(firstIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean insert(int newIndex) {
            Lock lock = BackgroundClassFinderIndex.this.packageIndicesLock.writeLock();
            lock.lock();
            try {
                boolean bl = super.insert(newIndex);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void append(int newIndex) {
            Lock lock = BackgroundClassFinderIndex.this.packageIndicesLock.writeLock();
            lock.lock();
            try {
                super.append(newIndex);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public int size() {
            Lock lock = BackgroundClassFinderIndex.this.packageIndicesLock.readLock();
            lock.lock();
            try {
                int n = super.size();
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        int[] rawAccess() {
            Lock lock = BackgroundClassFinderIndex.this.packageIndicesLock.readLock();
            lock.lock();
            try {
                int[] nArray = super.rawAccess();
                return nArray;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int get(int offset) {
            Lock lock = BackgroundClassFinderIndex.this.packageIndicesLock.readLock();
            lock.lock();
            try {
                int n = super.get(offset);
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public synchronized int getPackageDefinedIndex() {
            return super.getPackageDefinedIndex();
        }

        @Override
        public synchronized void setPackageDefinedIndex(int packageDefinedIndex) {
            super.setPackageDefinedIndex(packageDefinedIndex);
        }
    }
}

