/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders.debug;

import java.util.HashSet;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.classloaders.debug.RecordTrace;

class Trigger {
    private static final DebugLogger ctDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingContextualTrace");
    private final RecordTrace recordTrace;
    private String triggeringThrowablesStringValue = null;
    private Set<Class> triggeringThrowables;
    private final Set<Class> triggeringThrowablesDefaultSet = new HashSet<Class>();

    Trigger(RecordTrace recordTrace) {
        this.recordTrace = recordTrace;
        this.triggeringThrowablesDefaultSet.add(ClassNotFoundException.class);
        this.triggeringThrowablesDefaultSet.add(ClassFormatError.class);
        this.triggeringThrowablesDefaultSet.add(NoClassDefFoundError.class);
        this.triggeringThrowablesDefaultSet.add(UnsatisfiedLinkError.class);
        this.triggeringThrowables = this.triggeringThrowablesDefaultSet;
        this.checkAndSetTriggeringThrowables();
        if (ctDebugLogger.isDebugEnabled()) {
            this.dumpTriggeringThrowables();
        }
    }

    private void checkAndSetTriggeringThrowables() {
        String paramValue = ctDebugLogger.getDebugParameters().get("ErrorTrigger");
        if (paramValue == null && this.triggeringThrowablesStringValue != null) {
            this.triggeringThrowables = this.triggeringThrowablesDefaultSet;
            this.triggeringThrowablesStringValue = null;
            this.dumpTriggeringThrowables();
        } else if (!(paramValue == null || this.triggeringThrowablesStringValue != null && paramValue.equals(this.triggeringThrowablesStringValue))) {
            this.triggeringThrowables = new HashSet<Class>();
            for (String et : paramValue.split(",")) {
                try {
                    this.triggeringThrowables.add(Class.forName(et));
                }
                catch (Throwable e) {
                    ctDebugLogger.debug("Unable to load error class for filtering" + et);
                }
            }
            this.triggeringThrowablesStringValue = paramValue;
            this.dumpTriggeringThrowables();
        }
    }

    private void dumpTriggeringThrowables() {
        for (Class c : this.triggeringThrowables) {
            ctDebugLogger.debug("Contextual Trace Triggering Throwable = " + c.getName());
        }
    }

    boolean checkAndDump(Throwable e, StringBuilder builder, StackTraceElement[] triggerStackTrace, int triggerStackTraceOffset) {
        String throwableMessageFilter = ctDebugLogger.getDebugParameters().get("ThrowableMessageFilter");
        String resourceFilter = ctDebugLogger.getDebugParameters().get("ResourceTrigger");
        this.checkAndSetTriggeringThrowables();
        if (this.triggeringThrowables.contains(e.getClass()) && (throwableMessageFilter == null || throwableMessageFilter != null && e.getMessage().contains(throwableMessageFilter)) && this.recordTrace.size() > 0) {
            this.recordTrace.dump(Thread.currentThread(), builder, e.getClass().getSimpleName(), triggerStackTrace, triggerStackTraceOffset);
            return true;
        }
        return false;
    }

    boolean checkAndDump(String resourceName, StringBuilder builder, StackTraceElement[] triggerStackTrace, int triggerStackTraceOffset) {
        String throwableMessageFilter = ctDebugLogger.getDebugParameters().get("ThrowableMessageFilter");
        String resourceFilter = ctDebugLogger.getDebugParameters().get("ResourceTrigger");
        if (resourceFilter != null && resourceName.contains(resourceFilter) && this.recordTrace.size() > 0) {
            this.recordTrace.dump(Thread.currentThread(), builder, resourceName, triggerStackTrace, triggerStackTraceOffset);
            return true;
        }
        return false;
    }
}

