/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders.debug;

import java.util.HashMap;
import java.util.Map;
import weblogic.utils.classloaders.ChangeAwareClassLoader;
import weblogic.utils.classloaders.FilteringClassLoader;
import weblogic.utils.classloaders.GenericClassLoader;

public enum SupportedClassLoader {
    GCL(GenericClassLoader.class.getName()),
    FCL(FilteringClassLoader.class.getName()),
    CACL(ChangeAwareClassLoader.class.getName());

    private final String className;
    private static Map<String, String> acronyms;

    private SupportedClassLoader(String className) {
        this.className = className;
    }

    public static SupportedClassLoader fromClass(Class<? extends GenericClassLoader> c) {
        return SupportedClassLoader.valueOf(SupportedClassLoader.getAcronym(c.getSimpleName()));
    }

    public static boolean isSupported(Class<? extends GenericClassLoader> clz) {
        return SupportedClassLoader.isSupported(clz.getName());
    }

    public static boolean isSupported(String className) {
        for (SupportedClassLoader type : SupportedClassLoader.values()) {
            if (!type.className.equals(className)) continue;
            return true;
        }
        return false;
    }

    private static String getAcronym(String simpleName) {
        if (acronyms == null) {
            acronyms = new HashMap<String, String>();
        }
        if (acronyms.containsKey(simpleName)) {
            return acronyms.get(simpleName);
        }
        StringBuilder builder = new StringBuilder();
        for (char c : simpleName.toCharArray()) {
            if (c < 'A' || c > 'Z') continue;
            builder.append(c);
        }
        String acronym = builder.toString();
        acronyms.put(simpleName, acronym);
        return acronym;
    }
}

