/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders.debug;

import java.util.ArrayList;
import java.util.List;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.debug.ClasspathElement;

class ClasspathElementImpl
implements ClasspathElement {
    private String path = null;
    private List<ClasspathElement> children;
    private final ClasspathElement parent;

    public ClasspathElementImpl(ClassFinder finder, ClasspathElement parent) {
        if (finder instanceof JarClassFinder) {
            this.path = ((JarClassFinder)finder).getDelegate().getClassPath();
            this.initAndGetChildren().add(new ClasspathElementImpl(finder.getManifestFinder(), this));
        } else if (finder instanceof MultiClassFinder) {
            for (ClassFinder f : ((MultiClassFinder)finder).getClassFinders()) {
                this.initAndGetChildren().add(new ClasspathElementImpl(f, this));
            }
        } else {
            String classpath = finder.getClassPath();
            if (classpath != null && !classpath.isEmpty()) {
                String[] pathElements;
                for (String pathElement : pathElements = StringUtils.splitCompletely(finder.getClassPath(), PlatformConstants.PATH_SEP)) {
                    this.initAndGetChildren().add(new ClasspathElementImpl(pathElement, null, this));
                }
            }
        }
        this.parent = parent;
    }

    private ClasspathElementImpl(String path, ClasspathElement node, ClasspathElement parent) {
        this.path = path;
        if (node != null) {
            this.initAndGetChildren().add(node);
        }
        this.parent = parent;
    }

    private List<ClasspathElement> initAndGetChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ClasspathElement>();
        }
        return this.children;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<ClasspathElement> getChildren() {
        return this.children;
    }

    @Override
    public ClasspathElement getParent() {
        return this.parent;
    }
}

