/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.AbstractClassFinder;
import weblogic.utils.classloaders.ClassArchiveFile;
import weblogic.utils.classloaders.JarArchiveFile;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.PackageIndexedClassFinder;
import weblogic.utils.classloaders.ShareableClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.ZipArchiveFile;
import weblogic.utils.classloaders.ZipClassFinderDelegate;
import weblogic.utils.zip.Handler;

public class ZipClassFinder
extends AbstractClassFinder
implements PackageIndexedClassFinder,
ShareableClassFinder {
    private static final Pattern JRE_VERSION_PATTERN = Pattern.compile("\\d+");
    private static final String MULTI_RELEASE_CLASS_PREFIX = "META-INF/versions/";
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    private static ZipClassFinderDelegate archiveFactory = f -> f.getName().endsWith(".jar") ? new JarArchiveFile(f) : new ZipArchiveFile(f);
    private final ClassArchiveFile archive;
    private final String path;
    private final Manifest manifest;
    private final Integer currentJdkRelease;
    private final Map<String, MultiReleaseEntry> multiReleaseEntries = new HashMap<String, MultiReleaseEntry>();
    private final boolean shareable;

    public static ZipClassFinder createClassFinder(File file) throws IOException {
        return new ZipClassFinder(file);
    }

    private ZipClassFinder(File file) throws IOException {
        this.path = file.getCanonicalPath();
        this.archive = archiveFactory.createArchive(file);
        this.currentJdkRelease = this.computeJreRelease();
        this.manifest = Optional.ofNullable(this.archive.getEntry(MANIFEST_ENTRY)).map(this::createManifest).orElse(null);
        this.shareable = this.isShareable(this.manifest);
        if (this.isMultiRelease(this.manifest) && this.currentJdkRelease != null) {
            this.computeMultiReleaseEntries();
        }
    }

    private Integer computeJreRelease() {
        String javaVersion = System.getProperty("java.version");
        Matcher matcher = JRE_VERSION_PATTERN.matcher(javaVersion);
        if (javaVersion.startsWith("1.") || !matcher.find()) {
            return null;
        }
        return Integer.parseInt(matcher.group(0));
    }

    private Manifest createManifest(ZipEntry entry) {
        try {
            return new Manifest(this.archive.getInputStream(entry));
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isShareable(Manifest manifest) {
        return "true".equals(this.getManifestMainAttributes(manifest).getValue("WebLogic-Shareable"));
    }

    private boolean isMultiRelease(Manifest manifest) {
        return "true".equals(this.getManifestMainAttributes(manifest).getValue("Multi-Release"));
    }

    private Attributes getManifestMainAttributes(Manifest manifest) {
        return Optional.ofNullable(manifest).map(Manifest::getMainAttributes).orElse(new Attributes());
    }

    private void computeMultiReleaseEntries() {
        for (ZipEntry zipEntry : this.archive) {
            if (!zipEntry.getName().startsWith(MULTI_RELEASE_CLASS_PREFIX)) continue;
            this.addMultiReleaseEntry(zipEntry.getName());
        }
    }

    private void addMultiReleaseEntry(String path) {
        MultiReleaseEntry entry = new MultiReleaseEntry(path);
        if (this.shouldAdd(entry)) {
            this.multiReleaseEntries.put(entry.resourcePath, entry);
        }
    }

    private boolean shouldAdd(MultiReleaseEntry entry) {
        return this.isSupportedForCurrentJdk(entry) && this.isReplacementForExistingCandidate(entry);
    }

    private boolean isSupportedForCurrentJdk(MultiReleaseEntry entry) {
        return this.currentJdkRelease != null && entry.release <= this.currentJdkRelease;
    }

    private boolean isReplacementForExistingCandidate(MultiReleaseEntry entry) {
        MultiReleaseEntry existingEntry = this.multiReleaseEntries.get(entry.resourcePath);
        return existingEntry == null || entry.release > existingEntry.release;
    }

    Manifest getManifest() {
        return this.manifest;
    }

    public ZipFile getZipFile() {
        return this.archive.getZipFile();
    }

    @Override
    public Source getSource(String name) {
        while (StringUtils.startsWith(name, '/')) {
            name = name.substring(1);
        }
        return Optional.of(name).map(this::toMultiRelease).map(this.archive::getEntry).map(this.archive::createSource).orElse(null);
    }

    private String toMultiRelease(String path) {
        return Optional.ofNullable(this.multiReleaseEntries.get(path)).map(MultiReleaseEntry::getPath).orElse(path);
    }

    @Override
    public String getClassPath() {
        return this.path;
    }

    @Override
    public Enumeration<Source> entries() {
        final Iterator<ZipEntry> iterator = this.archive.iterator();
        return new Enumeration<Source>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public Source nextElement() {
                return ZipClassFinder.this.archive.createSource((ZipEntry)iterator.next());
            }
        };
    }

    @Override
    public Collection<String> getPackageNames() {
        HashSet<String> set = new HashSet<String>();
        for (ZipEntry entry : this.archive) {
            String name;
            if (entry.isDirectory()) {
                name = entry.getName();
                set.add(MultiClassFinder.getResourceDirectoryPackageName(name));
                continue;
            }
            name = entry.getName();
            set.add(MultiClassFinder.getResourcePackageName(name));
        }
        set.add("");
        return set;
    }

    @Override
    public void close() {
        try {
            this.archive.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return super.toString() + " - path: '" + this.path + "'";
    }

    @Override
    public boolean isShareable() {
        return this.shareable;
    }

    static {
        Handler.init();
    }

    static class MultiReleaseEntry {
        static final Pattern MULTI_RELEASE_PATH = Pattern.compile("META-INF/versions/(\\d+)/(.+)");
        private final String path;
        private final int release;
        private final String resourcePath;

        MultiReleaseEntry(String path) {
            this.path = path;
            Matcher matcher = MULTI_RELEASE_PATH.matcher(path);
            if (matcher.matches()) {
                this.release = Integer.parseInt(matcher.group(1));
                this.resourcePath = matcher.group(2);
            } else {
                this.release = 0;
                this.resourcePath = null;
            }
        }

        String getPath() {
            return this.path;
        }
    }
}

