/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.utils.classloaders.ClassArchiveFile;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.ZipSource;

class ZipArchiveFile
implements ClassArchiveFile {
    private final ZipFile zipFile;

    ZipArchiveFile(File file) throws IOException {
        this.zipFile = new ZipFile(file);
    }

    @Override
    public String getName() {
        return this.zipFile.getName();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return (Iterator)((Object)this.zipFile.entries());
    }

    @Override
    public ZipEntry getEntry(String path) {
        return this.zipFile.getEntry(path);
    }

    @Override
    public Source createSource(ZipEntry entry) {
        return new ZipSource(this.zipFile, entry);
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.zipFile.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    public ZipFile getZipFile() {
        return this.zipFile;
    }
}

