/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import weblogic.utils.classloaders.Source;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StreamUtils;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class URLSource
implements Source {
    private final URLConnection conn;

    public URLSource(URL url) throws IOException {
        this.conn = url.openConnection();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.conn.getInputStream();
    }

    @Override
    public URL getURL() {
        return this.conn.getURL();
    }

    @Override
    public URL getCodeSourceURL() {
        return this.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() throws IOException {
        try (InputStream in = this.getInputStream();){
            int len = (int)this.length();
            if (len != -1) {
                byte[] res = new byte[len];
                DataIO.readFully(in, res);
                byte[] byArray = res;
                return byArray;
            }
            UnsyncByteArrayOutputStream out = new UnsyncByteArrayOutputStream();
            StreamUtils.writeTo(in, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Override
    public long lastModified() {
        return this.conn.getLastModified();
    }

    @Override
    public long length() {
        return this.conn.getContentLength();
    }
}

