/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassFinderIndex;
import weblogic.utils.classloaders.ClassFinderWalker;
import weblogic.utils.classloaders.DirectoryClassFinder;
import weblogic.utils.classloaders.MetadataAttachingFinder;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.ZipClassFinder;
import weblogic.utils.classloaders.index.BackgroundClassFinderIndex;
import weblogic.utils.classloaders.index.EagerClassFinderIndex;
import weblogic.utils.collections.CopyOnWriteArrayList;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.SequencingEnumerator;

public class MultiClassFinder
implements ClassFinder {
    private final List<ClassFinder> finders = new CopyOnWriteArrayList<ClassFinder>();
    private volatile FrozenInfo frozen = null;
    private volatile ClassFinderWalker walker = new SimpleClassFinderWalker();
    private static final boolean isUseIndex = Boolean.valueOf(System.getProperty("weblogic.application.classloader.useIndex", "true"));
    private static final boolean isIndexInBackground = Boolean.valueOf(System.getProperty("weblogic.application.classloader.indexInBackground", "false"));

    public MultiClassFinder() {
    }

    public MultiClassFinder(ClassFinder finder) {
        this.addFinder(finder);
    }

    protected boolean isUnmodifiable() {
        return false;
    }

    public void addFinder(ClassFinder finder) {
        if (finder == null) {
            throw new IllegalArgumentException("Cannot add null finder");
        }
        if (this.isUnmodifiable()) {
            throw new IllegalArgumentException("Finder is unmodifiable");
        }
        this.finders.add(finder);
        if (this.frozen != null) {
            this.handlePostFreezeAddition(this.finders.size() - 1, finder);
        }
    }

    protected int getFirstIndex() {
        return 0;
    }

    public void addFinderFirst(ClassFinder finder) {
        if (finder == null) {
            throw new IllegalArgumentException("Cannot add null finder");
        }
        if (this.isUnmodifiable()) {
            throw new IllegalArgumentException("Finder is unmodifiable");
        }
        int index = this.getFirstIndex();
        this.finders.add(index, finder);
        if (this.frozen != null) {
            this.handlePostFreezeAddition(index, finder);
        }
    }

    public static String getPackageName(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            return className.substring(0, lastDot);
        }
        return "";
    }

    public static String getResourcePackageName(String resourcePath) {
        while (StringUtils.startsWith(resourcePath, '/')) {
            resourcePath = resourcePath.substring(1);
        }
        int lastSlash = resourcePath.lastIndexOf(47);
        if (lastSlash > 0) {
            return resourcePath.substring(0, lastSlash).replace('/', '.');
        }
        return "";
    }

    public static String getResourceDirectoryPackageName(String resourcePath) {
        while (StringUtils.startsWith(resourcePath, '/')) {
            resourcePath = resourcePath.substring(1);
        }
        while (StringUtils.endsWith(resourcePath, '/')) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        return resourcePath.replace('/', '.');
    }

    protected final ClassFinderWalker getWalker() {
        return this.walker;
    }

    @Override
    public final Source getClassSource(String name) {
        Iterator<ClassFinder> i = this.walker.iterator(MultiClassFinder.getPackageName(name));
        while (i.hasNext()) {
            ClassFinder finder = i.next();
            Source src = finder.getClassSource(name);
            if (src == null) continue;
            return src;
        }
        return null;
    }

    @Override
    public final Source getSource(String name) {
        Iterator<ClassFinder> i = this.walker.iterator(MultiClassFinder.getResourcePackageName(name));
        while (i.hasNext()) {
            ClassFinder finder = i.next();
            Source src = finder.getSource(name);
            if (src == null) continue;
            return src;
        }
        return null;
    }

    @Override
    public final Enumeration<Source> getSources(final String name) {
        return new LazyEnumerationWithConversion<ClassFinder, Source>(this.walker.iterator(MultiClassFinder.getResourcePackageName(name))){

            @Override
            protected Enumeration<Source> convert(ClassFinder s) {
                return s.getSources(name);
            }
        };
    }

    void freeze(Runnable onStartOptimization, Runnable onFinishOptimization) {
        this.freezeRecursive(null, 0);
        if (isUseIndex) {
            if (onStartOptimization != null) {
                onStartOptimization.run();
            }
            this.index(onFinishOptimization);
        }
    }

    @Override
    public void freeze() {
        this.freezeRecursive(null, 0);
        if (isUseIndex) {
            this.index();
        }
    }

    private void freezeRecursive(MultiClassFinder parent, int myIndex) {
        this.frozen = new FrozenInfo(parent, myIndex);
        for (ClassFinder finder : this.finders) {
            if (finder instanceof MultiClassFinder) {
                ((MultiClassFinder)finder).freezeRecursive(this, myIndex);
            } else {
                finder.freeze();
            }
            ++myIndex;
        }
    }

    public void handlePostFreezeAddition(int effectiveIndex, ClassFinder finder) {
        if (this.frozen.parent != null) {
            this.frozen.parent.handlePostFreezeAddition(effectiveIndex + this.frozen.myIndex, finder);
        } else {
            this.walker.handlePostFreezeAddition(effectiveIndex, finder);
        }
    }

    private void index() {
        this.index(null);
    }

    private void index(Runnable onFinishOptimization) {
        this.walker = this.createIndexedWalker(this.getFlattenedListOfFinders(), onFinishOptimization);
    }

    protected ClassFinderIndex createIndexedWalker(List<ClassFinder> flatList) {
        return this.createIndexedWalker(flatList, null);
    }

    protected ClassFinderIndex createIndexedWalker(List<ClassFinder> flatList, Runnable onFinishOptimization) {
        ClassFinderIndex index = isIndexInBackground ? new BackgroundClassFinderIndex(flatList) : new EagerClassFinderIndex(flatList);
        index.build(onFinishOptimization);
        return index;
    }

    @Override
    public void close() {
        for (ClassFinder finder : this.finders) {
            finder.close();
        }
        this.frozen = null;
        this.walker = new SimpleClassFinderWalker();
        this.finders.clear();
    }

    @Override
    public final String getClassPath() {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        HashSet<String> got = new HashSet<String>();
        Iterator<ClassFinder> i = this.finders.iterator();
        while (i.hasNext()) {
            String cp = i.next().getClassPath();
            if (cp == null) continue;
            StringTokenizer st = new StringTokenizer(cp, PlatformConstants.PATH_SEP);
            while (st.hasMoreTokens()) {
                String element = st.nextToken();
                if (got.contains(element)) continue;
                sb.append(sep).append(element);
                sep = PlatformConstants.PATH_SEP;
                got.add(element);
            }
        }
        return sb.toString();
    }

    @Override
    public ClassFinder getManifestFinder() {
        MultiClassFinder mcf = new MultiClassFinder();
        for (ClassFinder finder : this.finders) {
            ClassFinder cf = finder.getManifestFinder();
            if (cf == null) continue;
            mcf.addFinder(cf);
        }
        return mcf;
    }

    @Override
    public Enumeration<Source> entries() {
        ArrayList<Enumeration<Source>> l = new ArrayList<Enumeration<Source>>();
        Iterator<ClassFinder> i = this.finders.iterator();
        while (i.hasNext()) {
            Enumeration<Source> e = i.next().entries();
            if (e == EmptyEnumerator.EMPTY) continue;
            l.add(e);
        }
        return new SequencingEnumerator<Source>(l.toArray(new Enumeration[l.size()]));
    }

    public ClassFinder[] getClassFinders() {
        return this.finders.toArray(new ClassFinder[this.finders.size()]);
    }

    public ClassFinder[] getClassFindersForAnnotationScan() {
        return this.getClassFinders();
    }

    public ClassFinder remove(int index) {
        if (this.isUnmodifiable()) {
            throw new IllegalArgumentException("Finder is unmodifiable");
        }
        if (this.frozen != null) {
            throw new IllegalArgumentException("Finder is frozen");
        }
        ClassFinder removed = this.finders.remove(index);
        return removed;
    }

    public void flatten() {
        List<ClassFinder> temp = this.getFlattenedListOfFinders();
        this.finders.clear();
        this.finders.addAll(temp);
    }

    public List<ClassFinder> getFlattenedListOfFinders() {
        ArrayList<ClassFinder> flatList = new ArrayList<ClassFinder>();
        HashSet<String> paths = new HashSet<String>();
        this.flatten(flatList, paths, this.finders, null);
        return flatList;
    }

    /*
     * WARNING - void declaration
     */
    private void flatten(List<ClassFinder> flatList, Set<String> paths, List<ClassFinder> finders, Object metadata) {
        for (ClassFinder classFinder : finders) {
            void var6_6;
            if (classFinder instanceof MetadataAttachingFinder && ((MetadataAttachingFinder)classFinder).getFinder() instanceof MultiClassFinder) {
                this.flatten(flatList, paths, ((MultiClassFinder)((MetadataAttachingFinder)classFinder).getFinder()).finders, ((MetadataAttachingFinder)classFinder).getMetadata());
                continue;
            }
            if (classFinder instanceof MultiClassFinder) {
                this.flatten(flatList, paths, ((MultiClassFinder)classFinder).finders, metadata);
                continue;
            }
            if (classFinder instanceof NullClassFinder) continue;
            String path = null;
            File file = null;
            if (classFinder instanceof ZipClassFinder) {
                file = new File(((ZipClassFinder)classFinder).getZipFile().getName());
            } else if (classFinder instanceof DirectoryClassFinder) {
                file = new File(((DirectoryClassFinder)classFinder).getPath());
            }
            if (file != null) {
                try {
                    path = file.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)("Could not create canonical path for " + file));
                }
            }
            if (metadata != null) {
                MetadataAttachingFinder<Object> metadataAttachingFinder = new MetadataAttachingFinder<Object>(classFinder, metadata);
            }
            if (path != null) {
                if (paths.contains(path)) continue;
                paths.add(path);
                flatList.add((ClassFinder)var6_6);
                continue;
            }
            flatList.add((ClassFinder)var6_6);
        }
    }

    public int size() {
        return this.finders.size();
    }

    private class SimpleClassFinderWalker
    implements ClassFinderWalker {
        private SimpleClassFinderWalker() {
        }

        @Override
        public Iterator<ClassFinder> iterator(String packageName) {
            final ArrayDeque its = new ArrayDeque();
            its.add(MultiClassFinder.this.finders.iterator());
            return new Iterator<ClassFinder>(){
                ClassFinder next = null;

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    return this.findNext();
                }

                @Override
                public ClassFinder next() {
                    if (this.next != null || this.findNext()) {
                        ClassFinder finder = this.next;
                        this.next = null;
                        return finder;
                    }
                    throw new NoSuchElementException();
                }

                private boolean findNext() {
                    Iterator last = (Iterator)its.peekLast();
                    if (last == null) {
                        this.next = null;
                        return false;
                    }
                    if (last.hasNext()) {
                        ClassFinder f = (ClassFinder)last.next();
                        if (f instanceof MultiClassFinder) {
                            its.addLast(((MultiClassFinder)f).finders.iterator());
                            return this.findNext();
                        }
                        this.next = f;
                        return true;
                    }
                    its.removeLast();
                    return this.findNext();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void handlePostFreezeAddition(int effectiveIndex, ClassFinder finder) {
        }
    }

    private static class FrozenInfo {
        private final MultiClassFinder parent;
        private final int myIndex;

        private FrozenInfo(MultiClassFinder parent, int myIndex) {
            this.parent = parent;
            this.myIndex = myIndex;
        }
    }

    private abstract class LazyEnumerationWithConversion<S, T>
    implements Enumeration<T> {
        private final Iterator<S> iterator;
        private Enumeration<T> current;

        public LazyEnumerationWithConversion(Iterator<S> iterator) {
            this.iterator = iterator;
            this.current = null;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.current != null && this.current.hasMoreElements()) {
                return true;
            }
            while (this.iterator.hasNext()) {
                this.current = this.convert(this.iterator.next());
                if (this.current == null || !this.current.hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T nextElement() {
            if (this.hasMoreElements()) {
                return this.current.nextElement();
            }
            throw new NoSuchElementException();
        }

        protected abstract Enumeration<T> convert(S var1);
    }
}

