/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.util.Enumeration;
import weblogic.utils.classloaders.AbstractClassFinder;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.Source;

public final class ModuleClassFinder
extends AbstractClassFinder {
    private final ClassFinder delegate;
    private final String moduleURI;

    public ModuleClassFinder(ClassFinder delegate, String moduleURI) {
        this.delegate = delegate;
        this.moduleURI = moduleURI + "#";
    }

    @Override
    public Source getSource(String name) {
        Source s = this.delegate.getSource(name);
        if (s == null && name.startsWith(this.moduleURI)) {
            s = this.delegate.getSource(name.substring(this.moduleURI.length(), name.length()));
        }
        return s;
    }

    public Enumeration getSources(String name) {
        Enumeration<Source> e = this.delegate.getSources(name);
        if ((e == null || !e.hasMoreElements()) && name.startsWith(this.moduleURI)) {
            e = this.delegate.getSources(name.substring(this.moduleURI.length(), name.length()));
        }
        return e;
    }

    @Override
    public Source getClassSource(String name) {
        Source s = this.delegate.getClassSource(name);
        if (s == null && name.startsWith(this.moduleURI)) {
            s = this.delegate.getClassSource(name.substring(this.moduleURI.length(), name.length()));
        }
        return s;
    }

    @Override
    public String getClassPath() {
        return this.delegate.getClassPath();
    }

    @Override
    public ClassFinder getManifestFinder() {
        return this.delegate.getManifestFinder();
    }

    public Enumeration entries() {
        return this.delegate.entries();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

