/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.util.ArrayList;
import java.util.Enumeration;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.DelegateFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.SourceWithMetadata;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.IteratorEnumerator;

public class MetadataAttachingFinder<K>
extends DelegateFinder {
    private K metadata;

    public MetadataAttachingFinder(ClassFinder finder, K metadata) {
        super(finder);
        this.metadata = metadata;
    }

    public K getMetadata() {
        return this.metadata;
    }

    @Override
    public Source getSource(String name) {
        Source s = super.getSource(name);
        if (s == null) {
            return null;
        }
        return new SourceWithMetadata<K>(s, this.metadata);
    }

    @Override
    public Enumeration<Source> getSources(String name) {
        Enumeration e = super.getSources(name);
        ArrayList<SourceWithMetadata<K>> l = null;
        if (e != null) {
            l = new ArrayList<SourceWithMetadata<K>>();
            while (e.hasMoreElements()) {
                Source s = (Source)e.nextElement();
                l.add(new SourceWithMetadata<K>(s, this.metadata));
            }
        }
        if (l == null) {
            return new EmptyEnumerator<Source>();
        }
        return new IteratorEnumerator<Source>(l.iterator());
    }
}

