/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassFinderUtils;
import weblogic.utils.classloaders.IndexedDirectoryClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.ZipClassFinder;
import weblogic.utils.enumerations.SequencingEnumerator;

public final class JarClassFinder
extends MultiClassFinder {
    private final ClassFinder delegate;
    private final ClassFinder manifestFinder;
    private boolean isUnmodifiable = false;

    public JarClassFinder(File f) throws IOException {
        this(f, new HashSet<String>());
    }

    public JarClassFinder(File f, Set<String> exclude) throws IOException {
        this(f, exclude, false);
    }

    public JarClassFinder(File f, Set<String> exclude, boolean enforceCase) throws IOException {
        ClassFinder mf;
        if (exclude == null) {
            throw new IllegalArgumentException("Null exclude set");
        }
        if (f.isDirectory()) {
            this.delegate = new IndexedDirectoryClassFinder(f, enforceCase);
            Manifest manifest = ClassFinderUtils.getManifest(f);
            mf = ClassFinderUtils.getManifestFinder(manifest, f.getPath(), exclude);
        } else {
            try {
                ZipClassFinder zipClassFinder = ZipClassFinder.createClassFinder(f);
                Manifest manifest = zipClassFinder.getManifest();
                mf = ClassFinderUtils.getManifestFinder(manifest, zipClassFinder.getClassPath(), exclude);
                this.delegate = zipClassFinder;
            }
            catch (IOException ioe) {
                ClassFinderUtils.checkArchive(f.getCanonicalPath(), ioe);
                IOException ex = new IOException(ioe.getMessage() + " for file : " + f.getCanonicalPath(), ioe);
                throw ex;
            }
        }
        this.manifestFinder = Optional.ofNullable(mf).orElse(NullClassFinder.NULL_FINDER);
        this.addFinder(this.delegate);
        this.addFinder(this.manifestFinder);
        this.isUnmodifiable = true;
    }

    @Override
    protected boolean isUnmodifiable() {
        return this.isUnmodifiable;
    }

    public ClassFinder getDelegate() {
        return this.delegate;
    }

    @Override
    public ClassFinder getManifestFinder() {
        return this.manifestFinder;
    }

    @Override
    public Enumeration<Source> entries() {
        return new SequencingEnumerator<Source>(new Enumeration[]{this.delegate.entries(), this.manifestFinder.entries()});
    }

    @Override
    public void close() {
        this.delegate.close();
        this.manifestFinder.close();
    }

    public String toString() {
        return super.toString() + " - delegate: '" + this.delegate + "'";
    }
}

