/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import com.oracle.classloader.PolicyClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.GenericSignatureFormatError;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jsr166e.LongAdder;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.server.ClassLoaderPerfCounter;
import weblogic.server.GlobalServiceLocator;
import weblogic.utils.Classpath;
import weblogic.utils.Hex;
import weblogic.utils.PlatformConstants;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ByteArraySource;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassLoadersLogger;
import weblogic.utils.classloaders.ClassLoadersTextTextFormatter;
import weblogic.utils.classloaders.ClassPreProcessor;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.CodeGenClassFinder;
import weblogic.utils.classloaders.FilteredResourceEnumeration;
import weblogic.utils.classloaders.GenericClassLoaderRegistry;
import weblogic.utils.classloaders.JarSource;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.classloaders.ResourceEnumeration;
import weblogic.utils.classloaders.SharedSource;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.debug.ClassLoaderDebugger;
import weblogic.utils.classloaders.debug.SupportedClassLoader;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.MappingEnumerator;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.FilenameEncoder;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public class GenericClassLoader
extends SecureClassLoader
implements ClassLoaderPerfCounter {
    private static final ClassPreProcessor.ClassPreProcessorSupport support;
    private static final Annotation DEFAULT;
    private static final AtomicBoolean isOptimizedEnvironment;
    private final Set<String> excludeClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final PerfCounter perf = new PerfCounter();
    private final CodeGenClassFinder finder;
    private volatile Annotation annotation = DEFAULT;
    private volatile ClassPreProcessor.ClassPreProcessorSupport instancePreProcessors;
    private static final boolean CLASSLOAD_CHECK_JAR_SIGNAGE;
    private volatile List<Pattern> classPatterns = Collections.emptyList();
    private volatile List<Pattern> resourcePatterns = Collections.emptyList();
    private final ClassLoader parent;
    private volatile GenericClassLoader altParent = null;
    private final Map<String, Package> packages = new ConcurrentHashMap<String, Package>();
    private static final DebugLogger vDebugLogger;
    private static final DebugLogger ctDebugLogger;
    private boolean ascendantsCached = false;
    private Set<ClassLoader> ascendantRefs = null;
    private Set<Integer> ascendantHashCodes = null;
    private final boolean delegateToParent;
    private static boolean writeMagicFailureDetails;
    private static volatile String expandedClasspath;
    private int cachedHashCode = 0;

    public GenericClassLoader(ClassLoader parent) {
        this(parent, true);
    }

    public GenericClassLoader(ClassLoader parent, boolean delegateToParent) {
        this(NullClassFinder.NULL_FINDER, parent, true, delegateToParent);
    }

    public GenericClassLoader(ClassFinder finder) {
        this(finder, Thread.currentThread().getContextClassLoader());
    }

    public GenericClassLoader(ClassFinder finder, ClassLoader parent) {
        this(finder, parent, false);
    }

    public GenericClassLoader(ClassFinder finder, ClassLoader parent, boolean noParentOK) {
        this(finder, parent, noParentOK, parent != null);
    }

    private GenericClassLoader(ClassFinder finder, ClassLoader parent, boolean noParentOK, boolean delegateToParent) {
        super(parent);
        GenericClassLoaderRegistry reg;
        if (finder == null) {
            throw new IllegalArgumentException("finder is null");
        }
        if (!noParentOK && parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        this.parent = parent;
        this.finder = new CodeGenClassFinder(finder);
        if (isOptimizedEnvironment.get() && (reg = (GenericClassLoaderRegistry)GlobalServiceLocator.getServiceLocator().getService(GenericClassLoaderRegistry.class, new java.lang.annotation.Annotation[0])) != null) {
            reg.registerGenericClassLoader(this);
        }
        this.delegateToParent = parent != null ? delegateToParent : false;
    }

    public static GenericClassLoader getRootClassLoader(ClassFinder finder) {
        return new GenericClassLoader(finder, null, true);
    }

    public synchronized void setAltParent(GenericClassLoader altParent) {
        if (altParent == null) {
            throw new IllegalArgumentException("Altrenate Parent may not be null");
        }
        if (this.altParent != null) {
            throw new IllegalStateException("Alternate Parent has alread been set to " + this.altParent + ".It may not be reset to " + altParent);
        }
        this.altParent = altParent;
    }

    public GenericClassLoader getAltParent() {
        return this.altParent;
    }

    public static void addClassPreProcessor(String className) {
        support.addClassPreProcessor(className);
    }

    public synchronized void addInstanceClassPreProcessor(ClassPreProcessor cpp) {
        if (this.instancePreProcessors == null) {
            this.instancePreProcessors = new ClassPreProcessor.ClassPreProcessorSupport(false);
        }
        this.instancePreProcessors.addClassPreProcessor(cpp);
    }

    public final synchronized void setAnnotation(Annotation a) {
        this.annotation = a;
    }

    public final Annotation getAnnotation() {
        return this.annotation;
    }

    public synchronized void setFilterList(List<String> filterList) {
        if (vDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "setFilterList", filterList.toString(), "Invoked from", new Exception().getStackTrace()[1].toString());
        }
        this.classPatterns = GenericClassLoader.makePatterns(filterList);
    }

    protected boolean isClassPatternListEmpty() {
        return this.classPatterns == null || this.classPatterns.isEmpty();
    }

    public synchronized void setResourceFilterList(List<String> resourceFilterList) {
        if (vDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "setResourceFilterList", resourceFilterList.toString(), "Invoked from", new Exception().getStackTrace()[1].toString());
        }
        this.resourcePatterns = GenericClassLoader.makePatterns(resourceFilterList);
    }

    protected boolean isResourcePatternListEmpty() {
        return this.resourcePatterns == null || this.resourcePatterns.isEmpty();
    }

    public List<Pattern> getClassPatterns() {
        return this.classPatterns;
    }

    public List<Pattern> getResourcePatterns() {
        return this.resourcePatterns;
    }

    private boolean matchesClassFilterList(String name) {
        for (Pattern pattern : this.classPatterns) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            if (vDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "matchesClassFilterList", name, matcher.group() + " index : " + matcher.start() + " end : " + matcher.end(), new Object[0]);
            }
            return true;
        }
        return false;
    }

    protected boolean matchesResourceFilterList(String name) {
        for (Pattern pattern : this.resourcePatterns) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            if (vDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "matchesResourceFilterList", name, matcher.group() + " index : " + matcher.start() + " end : " + matcher.end(), new Object[0]);
            }
            return true;
        }
        return false;
    }

    private static List<Pattern> makePatterns(List<String> filter) {
        if (filter == null || filter.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String pat : filter) {
            if (pat.endsWith("*")) {
                pat = pat.substring(0, pat.length() - 1);
            }
            if (pat.endsWith(".")) {
                pat = pat + "{0,1}";
            }
            Pattern p = Pattern.compile("^" + pat);
            patterns.add(p);
        }
        return patterns;
    }

    protected URL getResourceInternal(String name) {
        return this.getResourceInternal(name, !this.delegateToParent);
    }

    protected boolean getResourceInternalEntryTrace(String name) {
        boolean doTraceOrBeVerbose;
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        boolean bl = doTraceOrBeVerbose = doTrace || beVerbose;
        if (doTraceOrBeVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResourceInternal", name);
        }
        return beVerbose;
    }

    protected void getResourceMatchesFilterListEntryTrace(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResourceInternal", name, "Blocked on pattern match", new Object[0]);
        }
        if (ctDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResourceInternal", name, null);
        }
    }

    protected void getResourceNoMatchFilterListEntryTrace(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResourceInternal", name, "Delegating to parent", new Object[0]);
        }
    }

    protected URL doParentGetResourceInternal(String name) {
        return ((GenericClassLoader)this.parent).getResourceInternal(name);
    }

    protected URL doParentGetResource(String name) {
        return this.parent.getResource(name);
    }

    protected void getResourceNoMatchFilterListExitTrace(String name, URL u) {
        if (ctDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResourceInternal", name, u);
        }
    }

    protected void getResourceNoPatternListEntryTrace(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResourceInternal", name, "Delegating to parent", new Object[0]);
        }
    }

    protected void getResourceNoPatternListExitTrace(String name, URL u) {
        if (ctDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResourceInternal", name, u);
        }
    }

    protected void getResourcePatternListEntryTrace(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResourceInternal", name, "Blocked", new Object[0]);
        }
        if (ctDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResourceInternal", name, null);
        }
    }

    protected URL doAltParentGetResource(String name) {
        return this.altParent.getResourceInternal(name, !this.altParent.delegateToParent);
    }

    protected void getResourcePostParentDelegateTrace(String name, boolean beVerbose, URL u) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResourceInternal", name, "URL from parent getResourceInternal1", u);
        }
    }

    protected void getResourcePostFindResourceTrace(String name, boolean beVerbose, URL u) {
        if (beVerbose && u != null) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResourceInternal", name, "findResource returned", u);
        }
    }

    protected void getResourceInternalExitTrace(String name, URL u) {
        if (ctDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResourceInternal", name, u);
        }
    }

    protected URL getResourceInternal(String name, boolean disableParentDelegation) {
        boolean beVerbose = this.getResourceInternalEntryTrace(name);
        URL u = null;
        if (this.isParentGenericClassLoader()) {
            if (!this.isResourcePatternListEmpty()) {
                if (this.matchesResourceFilterList(name)) {
                    this.getResourceMatchesFilterListEntryTrace(name, beVerbose);
                } else {
                    this.getResourceNoMatchFilterListEntryTrace(name, beVerbose);
                    u = !disableParentDelegation ? this.doParentGetResourceInternal(name) : this.doParentGetResource(name);
                    this.getResourceNoMatchFilterListExitTrace(name, u);
                }
            } else if (this.isClassPatternListEmpty()) {
                this.getResourceNoPatternListEntryTrace(name, beVerbose);
                u = !disableParentDelegation ? this.doParentGetResourceInternal(name) : this.doParentGetResource(name);
                this.getResourceNoPatternListExitTrace(name, u);
            } else {
                this.getResourcePatternListEntryTrace(name, beVerbose);
            }
            if (u == null && this.shouldAltParentDelegate(disableParentDelegation)) {
                u = this.doAltParentGetResource(name);
            }
            this.getResourcePostParentDelegateTrace(name, beVerbose, u);
            if (u == null) {
                u = this.findResource(name);
                this.getResourcePostFindResourceTrace(name, beVerbose, u);
            }
        } else {
            u = this.getParentResource(name);
            if (u == null) {
                u = this.findResource(name);
            }
        }
        this.getResourceInternalExitTrace(name, u);
        return u;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "loadClass", name);
        }
        try {
            return this.loadClass(name, false);
        }
        catch (Error e) {
            if (doTrace) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
        catch (IllegalStateException ise) {
            if (doTrace) {
                ClassLoaderDebugger.debug(this, ise);
            }
            IllegalStateException ise2 = new IllegalStateException("class: " + name + ",loader: " + this, ise);
            throw ise2;
        }
        catch (ClassNotFoundException e) {
            if (doTrace) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String name, boolean resolve, boolean sharedModeLoading) throws ClassNotFoundException {
        long startTime = System.nanoTime();
        long startParentDelegate = 0L;
        long endParentDelegate = 0L;
        long startFindClass = 0L;
        long endFindClass = 0L;
        try {
            boolean bVerbose = this.loadClassEntryTrace(name);
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> clz = this.findLoadedClass(name);
                if (clz == null) {
                    if (this.shouldParentDelegate(sharedModeLoading, name, bVerbose)) {
                        startParentDelegate = System.nanoTime();
                        try {
                            clz = this.doParentDelegate(name);
                        }
                        finally {
                            endParentDelegate = System.nanoTime();
                        }
                    }
                    if (clz == null && this.shouldAltParentDelegate(sharedModeLoading)) {
                        if (startParentDelegate == 0L) {
                            startParentDelegate = System.nanoTime();
                        }
                        try {
                            clz = this.doAltParentDelegate(name, resolve, true);
                        }
                        finally {
                            endParentDelegate = System.nanoTime();
                        }
                    }
                    if (clz == null) {
                        startFindClass = System.nanoTime();
                        try {
                            clz = this.doFindClass(name);
                        }
                        finally {
                            endFindClass = System.nanoTime();
                        }
                    }
                }
                if (resolve) {
                    this.resolveClass(clz);
                }
                Class<?> clazz = clz;
                return clazz;
            }
        }
        finally {
            this.perf.recordStats(startTime, startParentDelegate, endParentDelegate, startFindClass, endFindClass);
        }
    }

    protected boolean loadClassEntryTrace(String name) {
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace || beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "loadClass", name);
        }
        return beVerbose;
    }

    protected boolean shouldParentDelegate(boolean sharedModeLoading, String name, boolean bVerbose) {
        boolean isSkip;
        boolean disableParentDelegation = this.parent == null || sharedModeLoading && !this.delegateToParent;
        boolean bl = isSkip = disableParentDelegation || !this.isClassPatternListEmpty() && this.matchesClassFilterList(name);
        if (isSkip && bVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "loadClass", name, "Parent delegation disabled or found filter match. Not checking with parent.", new Object[0]);
        }
        return !isSkip;
    }

    protected boolean shouldAltParentDelegate(boolean sharedModeLoading) {
        boolean disableParentDelegation = sharedModeLoading && !this.delegateToParent;
        return this.altParent != null && !disableParentDelegation;
    }

    protected Class<?> doParentDelegate(String name) {
        try {
            if (this.parent == null) {
                return null;
            }
            return this.parent.loadClass(name);
        }
        catch (Error e) {
            if (ctDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected Class<?> doAltParentDelegate(String name, boolean resolve, boolean sharedModeLoading) {
        try {
            return this.altParent.loadClass(name, resolve, sharedModeLoading);
        }
        catch (Error e) {
            if (ctDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected Class<?> doFindClass(String name) throws ClassNotFoundException {
        try {
            return this.findClass(name);
        }
        catch (Error e) {
            if (ctDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (ctDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
    }

    protected void getResourceEntryTrace(String name) {
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResource", name);
        }
    }

    protected void getResourceExitTrace(String name, URL u) {
        boolean doTraceOrBeVerbose;
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        boolean bl = doTraceOrBeVerbose = doTrace || vDebugLogger.isDebugEnabled();
        if (doTraceOrBeVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResource", name, u);
        }
        if (doTrace && u == null) {
            ClassLoaderDebugger.debug(this, name);
        }
    }

    protected URL getParentResource(String name) {
        return this.parent.getResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        long startTime = System.nanoTime();
        long startParentDelegate = 0L;
        long endParentDelegate = 0L;
        try {
            this.getResourceEntryTrace(name);
            boolean beVerbose = this.getResourceInternalEntryTrace(name);
            URL u = null;
            if (this.isParentGenericClassLoader()) {
                if (!this.isResourcePatternListEmpty()) {
                    if (this.matchesResourceFilterList(name)) {
                        this.getResourceMatchesFilterListEntryTrace(name, beVerbose);
                    } else {
                        this.getResourceNoMatchFilterListEntryTrace(name, beVerbose);
                        startParentDelegate = System.nanoTime();
                        try {
                            u = this.doParentGetResourceInternal(name);
                        }
                        finally {
                            endParentDelegate = System.nanoTime();
                        }
                        this.getResourceNoMatchFilterListExitTrace(name, u);
                    }
                } else if (this.isClassPatternListEmpty()) {
                    this.getResourceNoPatternListEntryTrace(name, beVerbose);
                    startParentDelegate = System.nanoTime();
                    try {
                        u = this.doParentGetResourceInternal(name);
                    }
                    finally {
                        endParentDelegate = System.nanoTime();
                    }
                    this.getResourceNoPatternListExitTrace(name, u);
                } else {
                    this.getResourcePatternListEntryTrace(name, beVerbose);
                }
                if (u == null && this.shouldAltParentDelegate(false)) {
                    if (startParentDelegate == 0L) {
                        startParentDelegate = System.nanoTime();
                    }
                    try {
                        u = this.doAltParentGetResource(name);
                    }
                    finally {
                        endParentDelegate = System.nanoTime();
                    }
                }
                this.getResourcePostParentDelegateTrace(name, beVerbose, u);
                if (u == null) {
                    u = this.findResource(name);
                    this.getResourcePostFindResourceTrace(name, beVerbose, u);
                }
            } else {
                startParentDelegate = System.nanoTime();
                try {
                    u = this.getParentResource(name);
                }
                finally {
                    endParentDelegate = System.nanoTime();
                }
                if (u == null) {
                    u = this.findResource(name);
                }
            }
            this.getResourceInternalExitTrace(name, u);
            if (u == null && this.isResourceSearchOrderPreferred(name)) {
                if (endParentDelegate != 0L) {
                    startParentDelegate = System.nanoTime() - (endParentDelegate - startParentDelegate);
                }
                try {
                    u = this.getParentResource(name);
                    if (u == null) {
                        u = this.findResource(name);
                    }
                }
                finally {
                    endParentDelegate = System.nanoTime();
                }
            }
            this.getResourceExitTrace(name, u);
            URL uRL = u;
            return uRL;
        }
        finally {
            this.perf.recordResourceStats(startTime, startParentDelegate, endParentDelegate);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getResources(name, !this.delegateToParent);
    }

    protected boolean getResourcesEntryTrace(String name) {
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        if (beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResources", name);
        }
        return beVerbose;
    }

    protected boolean isParentGenericClassLoader() {
        return this.parent != null && this.parent instanceof GenericClassLoader;
    }

    protected void getResourcesParentEntryTrace(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResources", name, "getResources calling parent", new Object[0]);
        }
    }

    protected Enumeration<URL> getResourcesParentDelegationDisabled(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResources", name, "Parent delegation disabled or blocked on pattern match", new Object[0]);
        }
        return new ResourceEnumeration(new EmptyEnumerator());
    }

    protected Enumeration<URL> getResourcesMatchesResourceFilterList(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResources", name, "Parent delegation disabled or blocked on pattern match", new Object[0]);
        }
        return new ResourceEnumeration(new EmptyEnumerator());
    }

    protected Enumeration<URL> wrapAsResourceEnumeration(Enumeration<URL> urls) {
        return urls instanceof ResourceEnumeration ? urls : new ResourceEnumeration(urls);
    }

    protected Enumeration<URL> getParentResources(String name) throws IOException {
        return this.parent == null ? null : this.parent.getResources(name);
    }

    protected void getResourcesNoMatchResourceFilterListEntryTrace(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResources", name, "Delegating to parent", new Object[0]);
        }
    }

    protected void getResourcesNoPatternListEntryTrace(String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getResources", name, "Adopting default behavior", new Object[0]);
        }
    }

    protected Enumeration<URL> wrapAsFilteredResourceEnumeration(Enumeration<URL> urls) {
        return new FilteredResourceEnumeration(urls);
    }

    protected void doAltParentGetResources(Enumeration<URL> urls, String name) throws IOException {
        ((ResourceEnumeration)urls).addEnumeration(this.altParent.getResources(name, !this.altParent.delegateToParent));
    }

    protected void doFindResources(Enumeration<URL> urls, String name) throws IOException {
        ((ResourceEnumeration)urls).addEnumeration(this.findResources(name));
    }

    protected void getResourcesExitTrace(Enumeration<URL> urls, String name, boolean beVerbose) {
        if (beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResources", name, urls);
        }
    }

    protected Enumeration<URL> compound(final Enumeration<URL> one, final Enumeration<URL> two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return one.hasMoreElements() || two.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                return one.hasMoreElements() ? (URL)one.nextElement() : (URL)two.nextElement();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration<URL> getResources(String name, boolean disableParentDelegation) throws IOException {
        long startTime = System.nanoTime();
        long startParentDelegate = 0L;
        long endParentDelegate = 0L;
        try {
            Enumeration<URL> urls;
            boolean beVerbose = this.getResourcesEntryTrace(name);
            if (this.isParentGenericClassLoader()) {
                this.getResourcesParentEntryTrace(name, beVerbose);
                if (disableParentDelegation) {
                    urls = this.getResourcesParentDelegationDisabled(name, beVerbose);
                } else if (!this.isResourcePatternListEmpty()) {
                    if (this.matchesResourceFilterList(name)) {
                        urls = this.getResourcesMatchesResourceFilterList(name, beVerbose);
                    } else {
                        this.getResourcesNoMatchResourceFilterListEntryTrace(name, beVerbose);
                        urls = this.wrapAsResourceEnumeration(this.getParentResources(name));
                    }
                } else {
                    this.getResourcesNoPatternListEntryTrace(name, beVerbose);
                    startParentDelegate = System.nanoTime();
                    try {
                        urls = this.getParentResources(name);
                        urls = this.isClassPatternListEmpty() ? this.wrapAsResourceEnumeration(urls) : this.wrapAsFilteredResourceEnumeration(urls);
                    }
                    finally {
                        endParentDelegate = System.nanoTime();
                    }
                }
                if (this.shouldAltParentDelegate(disableParentDelegation)) {
                    if (startParentDelegate == 0L) {
                        startParentDelegate = System.nanoTime();
                    }
                    try {
                        this.doAltParentGetResources(urls, name);
                    }
                    finally {
                        endParentDelegate = System.nanoTime();
                    }
                }
                this.doFindResources(urls, name);
            } else {
                Enumeration<URL> parentResources;
                startParentDelegate = System.nanoTime();
                try {
                    parentResources = this.getParentResources(name);
                }
                finally {
                    endParentDelegate = System.nanoTime();
                }
                urls = this.compound(parentResources, this.findResources(name));
            }
            this.getResourcesExitTrace(urls, name, beVerbose);
            Enumeration<URL> enumeration = urls;
            return enumeration;
        }
        finally {
            this.perf.recordResourceStats(startTime, startParentDelegate, endParentDelegate);
        }
    }

    protected boolean isResourceSearchOrderPreferred(String name) {
        if (!this.isClassPatternListEmpty()) {
            return this.isResourcePatternListEmpty() || !this.isResourcePatternListEmpty() && !this.matchesResourceFilterList(name);
        }
        ClassLoader loader = this.parent;
        while (loader != null) {
            if (loader instanceof GenericClassLoader) {
                return ((GenericClassLoader)loader).isResourceSearchOrderPreferred(name);
            }
            loader = (ClassLoader)AccessController.doPrivileged(new GetClassLoaderParentAction(loader));
        }
        return false;
    }

    @Override
    protected URL findResource(String name) {
        boolean doTraceOrBeVerbose;
        boolean bl = doTraceOrBeVerbose = ctDebugLogger.isDebugEnabled() || vDebugLogger.isDebugEnabled();
        if (doTraceOrBeVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "findResource", name);
        }
        if ((name = FilenameEncoder.resolveRelativeURIPath(name, false)) == null) {
            return null;
        }
        Source s = this.finder.getSource(name);
        if (s == null) {
            return null;
        }
        URL url = s.getURL();
        if (doTraceOrBeVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "findResource", name, url);
        }
        return url;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        if (beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "findResources", name);
        }
        if ((name = FilenameEncoder.resolveRelativeURIPath(name, false)) == null) {
            return null;
        }
        Enumeration<Source> e = this.finder.getSources(name);
        if (beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "findResources", name, e);
        }
        return new MappingEnumerator<Source, URL>(e){

            @Override
            protected URL map(Source s) {
                return s.getURL();
            }
        };
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String baseName;
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "findClass", name);
        }
        if ((baseName = name).indexOf(36) != -1) {
            baseName = baseName.substring(0, baseName.indexOf(36));
        }
        if (this.excludeClasses.contains(baseName)) {
            if (vDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "findClass", name, "Arg found to be on the exclude set", new Object[0]);
            }
            ClassNotFoundException e = new ClassNotFoundException(name);
            if (doTrace) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
        try {
            if (name.startsWith("[") && name.endsWith(";")) {
                return this.findArrayClass(name);
            }
            return this.findLocalClass(name);
        }
        catch (UnsupportedClassVersionError e) {
            ClassLoadersLogger.wrongCompilerVersion(name, e);
            ClassNotFoundException ex = new ClassNotFoundException(ClassLoadersTextTextFormatter.getInstance().wrongCompilerVersion(name), e);
            if (doTrace) {
                ClassLoaderDebugger.debug(this, ex);
            }
            throw ex;
        }
        catch (GenericSignatureFormatError e) {
            AssertionError ae = new AssertionError("GenericSignatureError not expecded in findClass"){
                {
                    super(x0);
                    this.initCause(e);
                }
            };
            if (doTrace) {
                ClassLoaderDebugger.debug(this, (Throwable)((Object)ae));
            }
            throw ae;
        }
        catch (ClassFormatError cfe) {
            ClassLoadersLogger.unexpectedClassFormatError(name, cfe);
            ClassNotFoundException ex = new ClassNotFoundException("Class bytes found but defineClass()failed for: '" + name + "'", cfe);
            if (doTrace) {
                ClassLoaderDebugger.debug(this, ex);
            }
            throw ex;
        }
        catch (Error e) {
            if (doTrace) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (doTrace) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
    }

    private Class<?> findLocalClass(String name) throws ClassNotFoundException {
        Source s;
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "findLocalClass", name, "Classpath in use", this.finder.getClassPath());
        }
        if ((s = this.finder.getClassSource(name)) == null) {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "findLocalClass", name, "not found", new Object[0]);
            }
            throw new ClassNotFoundException(name);
        }
        if (s instanceof SharedSource) {
            return ((SharedSource)s).getSharedClass(name);
        }
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "findLocalClass", name, "Found class", new Object[0]);
        }
        return this.defineClass(name, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> defineClass(String name, Source s) throws ClassNotFoundException {
        long startTime = System.nanoTime();
        try {
            Class<?> clazz = this.defineClassInternal(name, s);
            return clazz;
        }
        finally {
            this.perf.recordDefineClassStats(startTime);
        }
    }

    private Class<?> defineClassInternal(String name, Source s) throws ClassNotFoundException {
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "defineClass", name);
        }
        Manifest man = null;
        Certificate[] certs = null;
        byte[] bytes = null;
        this.finder.addCodeGenSource(name, s);
        if (s instanceof JarSource) {
            JarSource js = (JarSource)s;
            try {
                man = js.getManifest();
                if (CLASSLOAD_CHECK_JAR_SIGNAGE) {
                    bytes = js.getBytes();
                    certs = js.getCertificates();
                }
            }
            catch (IOException ioe) {
                ClassLoadersLogger.errorReadingJarFile(s.getURL().toString(), ioe);
            }
        }
        try {
            if (bytes == null) {
                bytes = s.getBytes();
            }
        }
        catch (IOException ioe) {
            ClassNotFoundException e = new ClassNotFoundException(name, ioe);
            if (doTrace) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
        try {
            Class<?> c;
            block22: {
                URL codeSourceURL;
                block21: {
                    try {
                        this.checkMagicNumber(bytes, name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw this.getExtendedMajicFailureException(name, s, bytes, cnfe);
                    }
                    bytes = this.doPreProcess(bytes, name);
                    codeSourceURL = s.getCodeSourceURL();
                    try {
                        this.definePackage(name, man, codeSourceURL);
                    }
                    catch (IllegalArgumentException iae) {
                        String pname;
                        int i = name.lastIndexOf(46);
                        if (i < 0 || this.getPackage(pname = name.substring(0, i)) != null) break block21;
                        throw iae;
                    }
                }
                CodeSource codeSource = new CodeSource(codeSourceURL, certs);
                try {
                    c = this.defineClass(name, bytes, 0, bytes.length, codeSource);
                }
                catch (LinkageError e) {
                    c = this.findLoadedClass(name);
                    if (c != null) break block22;
                    throw e;
                }
            }
            if (vDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "defineClass", name, "Defined class", c);
            }
            return c;
        }
        catch (Error e) {
            if (doTrace) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (doTrace) {
                ClassLoaderDebugger.debug(this, e);
            }
            throw e;
        }
    }

    private ClassNotFoundException getExtendedMajicFailureException(String name, Source s, byte[] bytes, ClassNotFoundException cnfe) {
        if (writeMagicFailureDetails) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.println();
            pw.println("Failed to read the magic number from class " + name);
            pw.println("   location: " + s.getCodeSourceURL() + ", " + s.getURL());
            pw.print("   class bytes start after the arrow -->");
            for (byte b : bytes) {
                pw.print(b);
            }
            pw.println("<-- class bytes end before the arrow.");
            pw.flush();
            return new ClassNotFoundException(baos.toString());
        }
        return cnfe;
    }

    public byte[] doPreProcess(byte[] bytes, String name) {
        if (this.instancePreProcessors != null) {
            bytes = this.instancePreProcessors.preProcess(name, bytes);
        }
        return support.preProcess(name, bytes);
    }

    private Class<?> findArrayClass(String name) throws ClassNotFoundException {
        int arrayDim = 0;
        while (name.charAt(arrayDim) == '[') {
            ++arrayDim;
        }
        name = name.substring(arrayDim + 1, name.length() - 1);
        Class<?> c = this.loadClass(name);
        return Array.newInstance(c, new int[arrayDim]).getClass();
    }

    public String getClassPath() {
        StringBuilder sb = new StringBuilder();
        this.getClassPath(sb, true);
        return sb.toString();
    }

    private void getClassPath(StringBuilder sb, boolean includeParentCP) {
        String finderClasspath;
        if (includeParentCP) {
            this.getParentClassPath(sb);
        }
        if ((finderClasspath = this.getFinderClassPath()) != null && !finderClasspath.equals("")) {
            if (sb.length() > 0) {
                sb.append(PlatformConstants.PATH_SEP);
            }
            sb.append(finderClasspath);
        }
    }

    protected final void getParentClassPath(StringBuilder sb) {
        String parentClasspath = this.parent instanceof GenericClassLoader ? ((GenericClassLoader)this.parent).getClassPath() : GenericClassLoader.getExpanded();
        if (parentClasspath != null && !parentClasspath.equals("")) {
            if (sb.length() > 0) {
                sb.append(PlatformConstants.PATH_SEP);
            }
            sb.append(parentClasspath);
        }
        if (this.altParent != null) {
            this.altParent.getClassPath(sb, false);
        }
    }

    public final String getFinderClassPath() {
        return this.finder.getClassPath();
    }

    public final void excludeClass(String name) {
        this.excludeClasses.add(name);
    }

    private void checkMagicNumber(byte[] bytes, String name) throws ClassNotFoundException {
        try {
            int magic = DataIO.readInt(new UnsyncByteArrayInputStream(bytes));
            if (magic != -889275714) {
                if (vDebugLogger.isDebugEnabled()) {
                    ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "checkMagicNumber", name, "Bad bytes for class", Hex.dump(bytes));
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (IOException ioe) {
            if (vDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "checkMagicNumber", name, "Exception while trying to verify magic", ioe.getMessage());
                ioe.printStackTrace();
            }
            throw new ClassNotFoundException(name);
        }
    }

    private static String getAttributeValue(Attributes.Name n, Attributes a, Attributes b) {
        String returnValue = null;
        if (a != null) {
            returnValue = a.getValue(n);
        }
        if (returnValue == null && b != null) {
            returnValue = b.getValue(n);
        }
        return returnValue;
    }

    private void definePackage(String className, Manifest man, URL codeSourceURL) {
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return;
        }
        String pname = className.substring(0, i);
        Package p = this.getPackage(pname);
        if (p != null) {
            return;
        }
        Attributes pathAttributes = null;
        Attributes mainAttributes = null;
        if (man != null) {
            String path = pname.replace('.', '/').concat("/");
            pathAttributes = man.getAttributes(path);
            mainAttributes = man.getMainAttributes();
        }
        String specTitle = GenericClassLoader.getAttributeValue(Attributes.Name.SPECIFICATION_TITLE, pathAttributes, mainAttributes);
        String specVersion = GenericClassLoader.getAttributeValue(Attributes.Name.SPECIFICATION_VERSION, pathAttributes, mainAttributes);
        String specVendor = GenericClassLoader.getAttributeValue(Attributes.Name.SPECIFICATION_VENDOR, pathAttributes, mainAttributes);
        String implTitle = GenericClassLoader.getAttributeValue(Attributes.Name.IMPLEMENTATION_TITLE, pathAttributes, mainAttributes);
        String implVersion = GenericClassLoader.getAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, pathAttributes, mainAttributes);
        String implVendor = GenericClassLoader.getAttributeValue(Attributes.Name.IMPLEMENTATION_VENDOR, pathAttributes, mainAttributes);
        String sealed = GenericClassLoader.getAttributeValue(Attributes.Name.SEALED, pathAttributes, mainAttributes);
        URL sealBase = "true".equalsIgnoreCase(sealed) ? codeSourceURL : null;
        this.definePackage(pname, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    public void freezeClassFinder() {
        final long obt = System.nanoTime();
        Runnable onBeginIndexing = new Runnable(){

            @Override
            public void run() {
                GenericClassLoader.this.perf.startingIndexing();
            }
        };
        Runnable onFinishIndexing = new Runnable(){

            @Override
            public void run() {
                GenericClassLoader.this.perf.finishedIndexing(System.nanoTime() - obt);
            }
        };
        this.freezeClassFinder(onBeginIndexing, onFinishIndexing);
    }

    protected void freezeClassFinder(Runnable onBeginOptimization, Runnable onEndOptimization) {
        this.finder.freeze(onBeginOptimization, onEndOptimization);
    }

    public final void addClassFinder(ClassFinder newFinder) {
        this.finder.addFinder(newFinder);
    }

    public final void addClassFinderFirst(ClassFinder newFinder) {
        this.finder.addFinderFirst(newFinder);
    }

    public final ClassFinder getClassFinder() {
        return this.finder;
    }

    public final void close() {
        GenericClassLoaderRegistry reg;
        this.finder.close();
        if (isOptimizedEnvironment.get() && (reg = (GenericClassLoaderRegistry)GlobalServiceLocator.getServiceLocator().getService(GenericClassLoaderRegistry.class, new java.lang.annotation.Annotation[0])) != null) {
            reg.unregisterGenericClassLoader(this);
        }
    }

    public final String toString() {
        return super.toString() + " finder: " + this.finder + " annotation: " + this.getAnnotation();
    }

    public final Class<?> defineCodeGenClass(String className, byte[] bytes, URL codebase) throws ClassFormatError, ClassNotFoundException {
        this.finder.addCodeGenSource(className, new ByteArraySource(bytes, codebase));
        return Class.forName(className, true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getExpanded() {
        if (expandedClasspath != null) return expandedClasspath;
        Class<GenericClassLoader> clazz = GenericClassLoader.class;
        synchronized (GenericClassLoader.class) {
            if (expandedClasspath != null) return expandedClasspath;
            try (ClasspathClassFinder2.NoValidate cf = null;){
                cf = new ClasspathClassFinder2.NoValidate(Classpath.get());
                expandedClasspath = cf.getNoDupExpandedClassPath();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return expandedClasspath;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getResourceAsStream", name);
        }
        InputStream stream = super.getResourceAsStream(name);
        if (doTrace && stream == null) {
            ClassLoaderDebugger.debug(this, name);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            Package pkg = this.getPackage(name);
            if (pkg != null) {
                throw new IllegalArgumentException(name);
            }
            pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            this.packages.put(name, pkg);
            return pkg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package getPackage(String name) {
        Package pkg;
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace || beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getPackage", name);
        }
        Map<String, Package> map = this.packages;
        synchronized (map) {
            pkg = this.packages.get(name);
        }
        if (pkg == null) {
            if (!this.isClassPatternListEmpty() && this.matchesClassFilterList(name)) {
                if (beVerbose) {
                    ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getPackage", name, "Found match, filtering parent check for pacakge", new Object[0]);
                }
            } else {
                pkg = super.getPackage(name);
                if (pkg != null) {
                    map = this.packages;
                    synchronized (map) {
                        Package pkg2 = this.packages.get(name);
                        if (pkg2 == null) {
                            this.packages.put(name, pkg);
                        } else {
                            pkg = pkg2;
                        }
                    }
                }
            }
        }
        return pkg;
    }

    @Override
    protected Package[] getPackages() {
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace || beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.GCL, "getPackages", "");
        }
        Package[] packages = super.getPackages();
        if (!this.isClassPatternListEmpty()) {
            LinkedList<Package> filteredPackages = new LinkedList<Package>();
            for (Package aPackage : packages) {
                String name = aPackage.getName();
                if (this.matchesClassFilterList(name)) {
                    if (!beVerbose) continue;
                    ClassLoaderDebugger.verbose(this, SupportedClassLoader.GCL, "getPackage", name, "Found match, filtering from a list of packages", new Object[0]);
                    continue;
                }
                filteredPackages.add(aPackage);
            }
            packages = filteredPackages.toArray(new Package[filteredPackages.size()]);
        }
        return packages;
    }

    @Override
    public long getLoadClassTime() {
        return this.perf.beforeIndexingLoadClassTime.sum() + this.perf.duringIndexingLoadClassTime.sum() + this.perf.afterIndexingLoadClassTime.sum();
    }

    @Override
    public long getLoadClassCount() {
        return this.perf.beforeIndexingLoadClassCount.sum() + this.perf.duringIndexingLoadClassCount.sum() + this.perf.afterIndexingLoadClassCount.sum();
    }

    @Override
    public long getFindClassTime() {
        return this.perf.beforeIndexingFindClassTime.sum() + this.perf.duringIndexingFindClassTime.sum() + this.perf.afterIndexingFindClassTime.sum();
    }

    @Override
    public long getFindClassCount() {
        return this.perf.beforeIndexingFindClassCount.sum() + this.perf.duringIndexingFindClassCount.sum() + this.perf.afterIndexingFindClassCount.sum();
    }

    @Override
    public long getResourceTime() {
        return this.perf.beforeIndexingResourceTime.sum() + this.perf.duringIndexingResourceTime.sum() + this.perf.afterIndexingResourceTime.sum();
    }

    @Override
    public long getResourceCount() {
        return this.perf.beforeIndexingResourceCount.sum() + this.perf.duringIndexingResourceCount.sum() + this.perf.afterIndexingResourceCount.sum();
    }

    @Override
    public long getDefineClassTime() {
        return this.perf.defineClassTime.sum();
    }

    @Override
    public long getDefineClassCount() {
        return this.perf.defineClassCount.sum();
    }

    @Override
    public long getParentDelegationTime() {
        return this.perf.parentDelegationTime.sum();
    }

    @Override
    public long getParentDelegationCount() {
        return this.perf.parentDelegationCount.sum();
    }

    @Override
    public long getIndexingTime() {
        return this.perf.optimizationTime.sum();
    }

    @Override
    public long getBeforeIndexingLoadClassTime() {
        return this.perf.beforeIndexingLoadClassTime.sum();
    }

    @Override
    public long getBeforeIndexingLoadClassCount() {
        return this.perf.beforeIndexingLoadClassCount.sum();
    }

    @Override
    public long getBeforeIndexingFindClassTime() {
        return this.perf.beforeIndexingFindClassTime.sum();
    }

    @Override
    public long getBeforeIndexingFindClassCount() {
        return this.perf.beforeIndexingFindClassCount.sum();
    }

    @Override
    public long getBeforeIndexingResourceTime() {
        return this.perf.beforeIndexingResourceTime.sum();
    }

    @Override
    public long getBeforeIndexingResourceCount() {
        return this.perf.beforeIndexingResourceCount.sum();
    }

    @Override
    public long getDuringIndexingLoadClassTime() {
        return this.perf.duringIndexingLoadClassTime.sum();
    }

    @Override
    public long getDuringIndexingLoadClassCount() {
        return this.perf.duringIndexingLoadClassCount.sum();
    }

    @Override
    public long getDuringIndexingFindClassTime() {
        return this.perf.duringIndexingFindClassTime.sum();
    }

    @Override
    public long getDuringIndexingFindClassCount() {
        return this.perf.duringIndexingFindClassCount.sum();
    }

    @Override
    public long getDuringIndexingResourceTime() {
        return this.perf.duringIndexingResourceTime.sum();
    }

    @Override
    public long getDuringIndexingResourceCount() {
        return this.perf.duringIndexingResourceCount.sum();
    }

    @Override
    public long getAfterIndexingLoadClassTime() {
        return this.perf.afterIndexingLoadClassTime.sum();
    }

    @Override
    public long getAfterIndexingLoadClassCount() {
        return this.perf.afterIndexingLoadClassCount.sum();
    }

    @Override
    public long getAfterIndexingFindClassTime() {
        return this.perf.afterIndexingFindClassTime.sum();
    }

    @Override
    public long getAfterIndexingFindClassCount() {
        return this.perf.afterIndexingFindClassCount.sum();
    }

    @Override
    public long getAfterIndexingResourceTime() {
        return this.perf.afterIndexingResourceTime.sum();
    }

    @Override
    public long getAfterIndexingResourceCount() {
        return this.perf.afterIndexingResourceCount.sum();
    }

    public int hashCode() {
        int h = this.cachedHashCode;
        if (h == 0) {
            this.cachedHashCode = h = super.hashCode();
        }
        return h;
    }

    public static void setOptimizedEnvironment() {
        isOptimizedEnvironment.set(true);
    }

    public void optimize() {
        PolicyClassLoader.clearLockMap((ClassLoader)this);
    }

    private synchronized void cacheAscendantsIfNotDone() {
        if (!this.ascendantsCached) {
            if (this.parent != null) {
                if (this.parent instanceof GenericClassLoader) {
                    this.cacheAscendantsForParentIfNotDoneAndAddToSelf((GenericClassLoader)this.parent);
                } else {
                    ClassLoader parentCL;
                    for (parentCL = this.parent; parentCL != null && !(parentCL instanceof GenericClassLoader); parentCL = parentCL.getParent()) {
                        this.instantiateAscendantCachesIfNotDone();
                        this.ascendantRefs.add(parentCL);
                        this.ascendantHashCodes.add(parentCL.hashCode());
                    }
                    if (parentCL instanceof GenericClassLoader) {
                        this.cacheAscendantsForParentIfNotDoneAndAddToSelf((GenericClassLoader)parentCL);
                    }
                }
            }
            if (this.altParent != null) {
                this.cacheAscendantsForParentIfNotDoneAndAddToSelf(this.altParent);
            }
            this.ascendantsCached = true;
        }
    }

    private synchronized void instantiateAscendantCachesIfNotDone() {
        int averageNumberOfAscendants = 8;
        if (this.ascendantRefs == null) {
            this.ascendantRefs = Collections.synchronizedSet(new HashSet(averageNumberOfAscendants));
        }
        if (this.ascendantHashCodes == null) {
            this.ascendantHashCodes = Collections.synchronizedSet(new HashSet(averageNumberOfAscendants));
        }
    }

    private synchronized void cacheAscendantsForParentIfNotDoneAndAddToSelf(GenericClassLoader parentCL) {
        parentCL.cacheAscendantsIfNotDone();
        this.instantiateAscendantCachesIfNotDone();
        this.ascendantRefs.addAll(parentCL.ascendantRefs);
        this.ascendantRefs.add(parentCL);
        this.ascendantHashCodes.addAll(parentCL.ascendantHashCodes);
        this.ascendantHashCodes.add(parentCL.hashCode());
    }

    public boolean isChildOf(ClassLoader cl) {
        this.cacheAscendantsIfNotDone();
        return this.ascendantRefs.contains(cl);
    }

    public boolean isChildOf(int clHashCode) {
        this.cacheAscendantsIfNotDone();
        return this.ascendantHashCodes.contains(clHashCode);
    }

    static {
        Class<LockSupport> ensureLoaded = LockSupport.class;
        ClassLoader.registerAsParallelCapable();
        support = new ClassPreProcessor.ClassPreProcessorSupport();
        DEFAULT = new Annotation("");
        isOptimizedEnvironment = new AtomicBoolean(false);
        CLASSLOAD_CHECK_JAR_SIGNAGE = !Boolean.getBoolean("weblogic.classloader.noJarSigners");
        vDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingVerbose");
        ctDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingContextualTrace");
        writeMagicFailureDetails = Boolean.getBoolean("weblogic.GenericClassLoader.write_magic_failure_details");
        expandedClasspath = null;
    }

    private static final class PerfCounter {
        private final LongAdder optimizationTime = new LongAdder();
        private final LongAdder beforeIndexingLoadClassTime = new LongAdder();
        private final LongAdder beforeIndexingLoadClassCount = new LongAdder();
        private final LongAdder beforeIndexingFindClassTime = new LongAdder();
        private final LongAdder beforeIndexingFindClassCount = new LongAdder();
        private final LongAdder beforeIndexingResourceTime = new LongAdder();
        private final LongAdder beforeIndexingResourceCount = new LongAdder();
        private final LongAdder duringIndexingLoadClassTime = new LongAdder();
        private final LongAdder duringIndexingLoadClassCount = new LongAdder();
        private final LongAdder duringIndexingFindClassTime = new LongAdder();
        private final LongAdder duringIndexingFindClassCount = new LongAdder();
        private final LongAdder duringIndexingResourceTime = new LongAdder();
        private final LongAdder duringIndexingResourceCount = new LongAdder();
        private final LongAdder afterIndexingLoadClassTime = new LongAdder();
        private final LongAdder afterIndexingLoadClassCount = new LongAdder();
        private final LongAdder afterIndexingFindClassTime = new LongAdder();
        private final LongAdder afterIndexingFindClassCount = new LongAdder();
        private final LongAdder afterIndexingResourceTime = new LongAdder();
        private final LongAdder afterIndexingResourceCount = new LongAdder();
        private final LongAdder defineClassTime = new LongAdder();
        private final LongAdder defineClassCount = new LongAdder();
        private final LongAdder parentDelegationTime = new LongAdder();
        private final LongAdder parentDelegationCount = new LongAdder();
        private Phase phase = new Phase();

        private PerfCounter() {
        }

        public void recordStats(long startTime, long startParentDelegate, long endParentDelegate, long startFindClass, long endFindClass) {
            long loadClassTime = startTime != 0L ? System.nanoTime() - startTime : 0L;
            long findClassTime = startFindClass != 0L ? endFindClass - startFindClass : 0L;
            this.phase.recordStats(loadClassTime, findClassTime);
            if (startParentDelegate != 0L) {
                this.parentDelegationTime.add(endParentDelegate - startParentDelegate);
                this.parentDelegationCount.increment();
            }
        }

        public void recordResourceStats(long startTime, long startParentDelegate, long endParentDelegate) {
            this.phase.recordResourceStats(startTime);
            if (startParentDelegate != 0L) {
                this.parentDelegationTime.add(endParentDelegate - startParentDelegate);
                this.parentDelegationCount.increment();
            }
        }

        public void recordDefineClassStats(long startTime) {
            this.defineClassTime.add(System.nanoTime() - startTime);
            this.defineClassCount.increment();
        }

        public synchronized void startingIndexing() {
            this.phase = new DuringPhase();
        }

        public synchronized void finishedIndexing(long optimizationTime) {
            this.phase = new AfterPhase();
            this.optimizationTime.add(optimizationTime);
        }

        private class AfterPhase
        extends Phase {
            private AfterPhase() {
            }

            @Override
            void recordStats(long loadClassTime, long findClassTime) {
                PerfCounter.this.afterIndexingLoadClassTime.add(loadClassTime);
                PerfCounter.this.afterIndexingLoadClassCount.increment();
                if (findClassTime > 0L) {
                    PerfCounter.this.afterIndexingFindClassTime.add(findClassTime);
                    PerfCounter.this.afterIndexingFindClassCount.increment();
                }
            }

            @Override
            void recordResourceStats(long startTime) {
                if (startTime > 0L) {
                    long time = System.nanoTime() - startTime;
                    PerfCounter.this.afterIndexingResourceTime.add(time);
                    PerfCounter.this.afterIndexingResourceCount.increment();
                }
            }
        }

        private class DuringPhase
        extends Phase {
            private DuringPhase() {
            }

            @Override
            void recordStats(long loadClassTime, long findClassTime) {
                PerfCounter.this.duringIndexingLoadClassTime.add(loadClassTime);
                PerfCounter.this.duringIndexingLoadClassCount.increment();
                if (findClassTime > 0L) {
                    PerfCounter.this.duringIndexingFindClassTime.add(findClassTime);
                    PerfCounter.this.duringIndexingFindClassCount.increment();
                }
            }

            @Override
            void recordResourceStats(long startTime) {
                if (startTime > 0L) {
                    long time = System.nanoTime() - startTime;
                    PerfCounter.this.duringIndexingResourceTime.add(time);
                    PerfCounter.this.duringIndexingResourceCount.increment();
                }
            }
        }

        private class Phase {
            private Phase() {
            }

            void recordStats(long loadClassTime, long findClassTime) {
                PerfCounter.this.beforeIndexingLoadClassTime.add(loadClassTime);
                PerfCounter.this.beforeIndexingLoadClassCount.increment();
                if (findClassTime > 0L) {
                    PerfCounter.this.beforeIndexingFindClassTime.add(findClassTime);
                    PerfCounter.this.beforeIndexingFindClassCount.increment();
                }
            }

            void recordResourceStats(long startTime) {
                if (startTime > 0L) {
                    long time = System.nanoTime() - startTime;
                    PerfCounter.this.beforeIndexingResourceTime.add(time);
                    PerfCounter.this.beforeIndexingResourceCount.increment();
                }
            }
        }
    }

    private class GetClassLoaderParentAction
    implements PrivilegedAction {
        ClassLoader clLoader = null;

        public GetClassLoaderParentAction(ClassLoader loader) {
            this.clLoader = loader;
        }

        public Object run() {
            if (this.clLoader != null) {
                return this.clLoader.getParent();
            }
            return this.clLoader;
        }
    }
}

