/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.classloaders.FilteredResourceEnumeration;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.ResourceEnumeration;
import weblogic.utils.classloaders.debug.ClassLoaderDebugger;
import weblogic.utils.classloaders.debug.SupportedClassLoader;
import weblogic.utils.enumerations.EmptyEnumerator;

public class FilteringClassLoader
extends GenericClassLoader {
    private volatile List<Pattern> classPatterns = Collections.emptyList();
    private volatile List<Pattern> resourcePatterns = Collections.emptyList();
    private volatile boolean enableResourceInternalSearch = false;
    private static final DebugLogger vDebugLogger;
    private static final DebugLogger ctDebugLogger;

    public FilteringClassLoader(ClassLoader parent) {
        super(parent);
        if (parent == null) {
            throw new IllegalArgumentException("parent ClassLoader must be non null");
        }
    }

    public FilteringClassLoader(ClassLoader parent, List filterList) {
        super(parent);
        this.classPatterns = FilteringClassLoader.makePatterns(filterList);
    }

    public synchronized void setFilterList(List filterList) {
        if (vDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "setFilterList", filterList.toString(), "Invoked from", new Exception().getStackTrace()[1].toString());
        }
        this.classPatterns = FilteringClassLoader.makePatterns(filterList);
    }

    @Override
    protected boolean isClassPatternListEmpty() {
        return this.classPatterns.isEmpty();
    }

    @Override
    public synchronized void setResourceFilterList(List<String> resourceFilterList) {
        if (vDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "setResourceFilterList", resourceFilterList.toString(), "Invoked from", new Exception().getStackTrace()[1].toString());
        }
        this.resourcePatterns = FilteringClassLoader.makePatterns(resourceFilterList);
    }

    @Override
    protected boolean isResourcePatternListEmpty() {
        return this.resourcePatterns.isEmpty();
    }

    public synchronized void setResourceInternalSearch(boolean enable) {
        this.enableResourceInternalSearch = enable;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "loadClass", name);
        }
        try {
            return this.loadClass(name, false);
        }
        catch (Error e) {
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "loadClass", name);
        }
        try {
            Class c = this.findClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        catch (Error e) {
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace || beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "findClass", name);
        }
        if (!this.isClassPatternListEmpty() && this.matchesClassFilterList(name)) {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "findClass", name, "Found match", new Object[0]);
            }
            ClassNotFoundException e = new ClassNotFoundException(name);
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
        return this.getParent().loadClass(name);
    }

    @Override
    protected URL getResourceInternal(String name) {
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResourceInternal", name);
        }
        if (!this.isResourcePatternListEmpty() && this.matchesResourceFilterList(name)) {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getResourceInternal", name, "Blocked on pattern match", new Object[0]);
            }
            if (doTrace) {
                ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResourceInternal", name, null);
            }
            return null;
        }
        if (this.isClassPatternListEmpty()) {
            ClassLoader parent;
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getResourceInternal", name, "Delegating to parent", new Object[0]);
            }
            if (this.enableResourceInternalSearch && (parent = this.getParent()) instanceof GenericClassLoader) {
                URL u = ((GenericClassLoader)parent).getResourceInternal(name);
                if (doTrace) {
                    ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResourceInternal", name, u);
                }
                return u;
            }
            URL u = this.getParent().getResource(name);
            if (doTrace) {
                ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResourceInternal", name, u);
            }
            return u;
        }
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getResourceInternal", name, "Blocked", new Object[0]);
        }
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResourceInternal", name, null);
        }
        return null;
    }

    @Override
    protected boolean isResourceSearchOrderPreferred(String name) {
        if (this.isClassPatternListEmpty()) {
            return super.isResourceSearchOrderPreferred(name);
        }
        return this.isResourcePatternListEmpty() || !this.isResourcePatternListEmpty() && !this.matchesResourceFilterList(name);
    }

    @Override
    public URL getResource(String name) {
        URL u;
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResource", name);
        }
        if (!this.isResourcePatternListEmpty() && this.matchesResourceFilterList(name)) {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getResource", name, "Resource lookup blocked on pattern match", new Object[0]);
            }
            u = null;
            if (doTrace) {
                ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResource", name, u);
            }
        } else {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getResource", name, "Delegating to parent", new Object[0]);
            }
            u = this.getParent().getResource(name);
            if (doTrace || beVerbose) {
                ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResource", name, u);
            }
        }
        if (doTrace && u == null) {
            ClassLoaderDebugger.debug((GenericClassLoader)this, name);
        }
        return u;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ResourceEnumeration e;
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        if (beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResources", name);
        }
        if (!this.isResourcePatternListEmpty() && this.matchesResourceFilterList(name)) {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getResources", name, "Blocked on pattern match", new Object[0]);
            }
            e = new EmptyEnumerator<URL>();
        } else {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getResources", name, "Adopting default behavior", new Object[0]);
            }
            e = this.getParent().getResources(name);
            e = this.isClassPatternListEmpty() ? (e instanceof ResourceEnumeration ? e : new ResourceEnumeration(e)) : new FilteredResourceEnumeration(e);
        }
        if (beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getResources", name, e);
        }
        return e;
    }

    public Enumeration findResources(String name) throws IOException {
        if (vDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "findResources", name);
        }
        return new EmptyEnumerator();
    }

    @Override
    public List<Pattern> getClassPatterns() {
        return this.classPatterns;
    }

    @Override
    public List<Pattern> getResourcePatterns() {
        return this.resourcePatterns;
    }

    private boolean matchesClassFilterList(String name) {
        for (Pattern pattern : this.classPatterns) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            if (vDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "matchesClassFilterList", name, matcher.group() + " index : " + matcher.start() + " end : " + matcher.end(), new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean matchesResourceFilterList(String name) {
        for (Pattern pattern : this.resourcePatterns) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            if (vDebugLogger.isDebugEnabled()) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "matchesResourceFilterList", name, matcher.group() + " index : " + matcher.start() + " end : " + matcher.end(), new Object[0]);
            }
            return true;
        }
        return false;
    }

    private static List<Pattern> makePatterns(List<String> filter) {
        if (filter == null || filter.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String pat : filter) {
            if (pat.endsWith("*")) {
                pat = pat.substring(0, pat.length() - 1);
            }
            if (pat.endsWith(".")) {
                pat = pat + "{0,1}";
            }
            Pattern p = Pattern.compile("^" + pat);
            patterns.add(p);
        }
        return patterns;
    }

    @Override
    protected Package getPackage(String name) {
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace || beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getPackage", name);
        }
        if (!this.isClassPatternListEmpty() && this.matchesClassFilterList(name)) {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getPackage", name, "Found match", new Object[0]);
            }
            return null;
        }
        return super.getPackage(name);
    }

    @Override
    protected Package[] getPackages() {
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace || beVerbose) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.FCL, "getPackages", "");
        }
        Package[] packages = super.getPackages();
        if (!this.isClassPatternListEmpty()) {
            LinkedList<Package> filteredPackages = new LinkedList<Package>();
            for (Package aPackage : packages) {
                String name = aPackage.getName();
                if (this.matchesClassFilterList(name)) {
                    if (!beVerbose) continue;
                    ClassLoaderDebugger.verbose(this, SupportedClassLoader.FCL, "getPackage", name, "Found match", new Object[0]);
                    continue;
                }
                filteredPackages.add(aPackage);
            }
            packages = filteredPackages.toArray(new Package[filteredPackages.size()]);
        }
        return packages;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        vDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingVerbose");
        ctDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingContextualTrace");
    }
}

