/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import weblogic.utils.classloaders.Source;
import weblogic.utils.io.DataIO;

public final class FileSource
implements Source {
    private static final int GET_BYTES_RETRIES = 3;
    private final File file;
    private final String codeBase;

    public FileSource(String codeBase, File file) {
        this.file = file;
        this.codeBase = codeBase;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public URL getURL() {
        return this.getURL(this.file);
    }

    private URL getURL(File f) {
        if (f.exists()) {
            try {
                return new File(f.toString().replaceAll("#", "%23")).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getCodeSourceURL() {
        return this.getURL(new File(this.codeBase));
    }

    @Override
    public byte[] getBytes() throws IOException {
        for (int i = 0; i < 3; ++i) {
            try {
                return this.getBytesInternal();
            }
            catch (IndexOutOfBoundsException iob) {
                try {
                    Thread.sleep((int)(Math.random() * (double)(0x64 ^ i)));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        try {
            return this.getBytesInternal();
        }
        catch (IndexOutOfBoundsException iob) {
            throw new IOException("Could not read from: '" + this.file + "' because some other process was writing it");
        }
    }

    private byte[] getBytesInternal() throws IOException {
        byte[] buf = new byte[(int)this.length()];
        InputStream in = this.getInputStream();
        DataIO.readFully(in, buf);
        in.close();
        return buf;
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    public String toString() {
        if (this.file != null) {
            return this.file.toString();
        }
        return "Unknown FileSource";
    }

    public File getFile() {
        return this.file;
    }

    public String getCodeBase() {
        return this.codeBase;
    }
}

