/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import weblogic.utils.io.FilenameEncoder;

public class DirectoryIndex {
    private Set<String> fileSet = new HashSet<String>();

    public DirectoryIndex(String path) throws IOException {
        try {
            File f = FilenameEncoder.getSafeFile(path, "." + File.separator).getParentFile();
            if (!f.isDirectory()) {
                throw new IOException(f.getCanonicalPath() + " is not a directory");
            }
            this.listFiles(f, null);
        }
        catch (FilenameEncoder.UnsafeFilenameException ignore) {
            throw new IOException(ignore.getMessage());
        }
    }

    public boolean contains(String fileName) {
        return this.fileSet.contains(fileName);
    }

    private void listFiles(File parent, String prefix) throws IOException {
        File[] files;
        for (File file : files = parent.listFiles()) {
            if (file.isDirectory()) {
                String newPrefix = prefix != null ? prefix + File.separator + file.getName() : file.getName();
                this.listFiles(file, newPrefix);
            }
            String key = prefix != null ? prefix + File.separator + file.getName() : file.getName();
            this.fileSet.add(key);
        }
    }

    public static void main(String[] args) throws IOException {
        new DirectoryIndex(args[0]);
    }
}

