/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.util.Enumeration;
import weblogic.utils.classloaders.AbstractClassFinder;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.enumerations.EmptyEnumerator;

final class CodeGenClassFinder
extends MultiClassFinder {
    private final ConcurrentHashMap<String, Source> classNameToSource = new ConcurrentHashMap();

    public CodeGenClassFinder() {
        this.addFinder(new SourceClassFinder());
    }

    public CodeGenClassFinder(ClassFinder finder) {
        this.addFinder(new SourceClassFinder());
        this.addFinder(finder);
    }

    public void addCodeGenSource(String name, Source source) {
        this.classNameToSource.putIfAbsent(name, source);
    }

    @Override
    protected int getFirstIndex() {
        return 1;
    }

    @Override
    public void close() {
        super.close();
        this.classNameToSource.clear();
    }

    private class SourceClassFinder
    extends AbstractClassFinder {
        private SourceClassFinder() {
        }

        @Override
        public Source getClassSource(String name) {
            return (Source)CodeGenClassFinder.this.classNameToSource.get(name);
        }

        @Override
        public Source getSource(String name) {
            if (name != null && name.endsWith(".class")) {
                return (Source)CodeGenClassFinder.this.classNameToSource.get(name.substring(0, name.length() - 6).replace('/', '.'));
            }
            return null;
        }

        public Enumeration getSources(String name) {
            return new EmptyEnumerator();
        }

        @Override
        public String getClassPath() {
            return null;
        }
    }
}

