/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.DelegateFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static boolean visibleToClassLoader(Object o) {
        ClassLoader ccl;
        ClassLoader ocl = o.getClass().getClassLoader();
        if (ocl == null) {
            return true;
        }
        for (ccl = Thread.currentThread().getContextClassLoader(); ccl != null && !(ccl instanceof GenericClassLoader); ccl = ccl.getParent()) {
            if (ccl != ocl) continue;
            return true;
        }
        if (ccl instanceof GenericClassLoader) {
            if (ccl == ocl) {
                return true;
            }
            if (((GenericClassLoader)ccl).isChildOf(ocl)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChild(int clHashCode, ClassLoader currentCL) {
        ClassLoader parent;
        if (currentCL instanceof GenericClassLoader) {
            return ((GenericClassLoader)currentCL).isChildOf(clHashCode);
        }
        for (parent = currentCL.getParent(); parent != null && !(parent instanceof GenericClassLoader); parent = parent.getParent()) {
            if (parent.hashCode() != clHashCode) continue;
            return true;
        }
        if (parent instanceof GenericClassLoader) {
            if (parent.hashCode() == clHashCode) {
                return true;
            }
            if (((GenericClassLoader)parent).isChildOf(clHashCode)) {
                return true;
            }
        }
        return false;
    }

    public static GenericClassLoader createTemporaryAppClassLoader(GenericClassLoader refAppClassLoader) {
        return ClassLoaderUtils.createAppClassLoader(refAppClassLoader, false, null);
    }

    public static GenericClassLoader createInterAppClassLoader(GenericClassLoader refAppClassLoader, ClassLoader parent) {
        return ClassLoaderUtils.createAppClassLoader(refAppClassLoader, true, parent);
    }

    private static GenericClassLoader createAppClassLoader(GenericClassLoader refAppClassLoader, boolean useParent, ClassLoader parent) {
        ClassFinder finder = new NonClosingClassFinder(refAppClassLoader.getClassFinder());
        if (refAppClassLoader.getAltParent() != null) {
            finder = new MultiClassFinder(finder);
            ((MultiClassFinder)finder).addFinderFirst(new NonClosingClassFinder(refAppClassLoader.getAltParent().getClassFinder()));
        }
        return new GenericClassLoader(finder, useParent ? parent : refAppClassLoader.getParent());
    }

    private static final class NonClosingClassFinder
    extends DelegateFinder {
        public NonClosingClassFinder(ClassFinder finder) {
            super(finder);
        }

        @Override
        public void close() {
        }
    }
}

