/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.utils.OptionalPackageProvider;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.BeaHomeHolder;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassLoadersLogger;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.debug.ClassLoaderDebugger;

public class ClassFinderUtils {
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    private static final String SHAREABLE_MANIFEST_ATTR_NAME = "WebLogic-Shareable";
    private static final String BEA_HOME_PLACEHOLDER = "@BEA_HOME@";

    private ClassFinderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(File dir) throws IOException {
        Manifest manifest;
        File manFile = new File(dir, MANIFEST_ENTRY);
        if (!manFile.exists()) {
            return null;
        }
        try (FileInputStream manFileStream = new FileInputStream(manFile);){
            manifest = new Manifest(manFileStream);
        }
        return manifest;
    }

    public static ClassFinder getManifestFinder(File dir, Set<String> exclude) throws IOException {
        return ClassFinderUtils.getManifestFinder(dir, exclude, null);
    }

    public static ClassFinder getManifestFinder(File dir, Set<String> exclude, Attr attr) throws IOException {
        return ClassFinderUtils.getManifestFinder(ClassFinderUtils.getManifest(dir), dir.getPath(), exclude, attr);
    }

    public static ClassFinder getManifestFinder(Manifest manifest, String path, Set<String> exclude) throws IOException {
        return ClassFinderUtils.getManifestFinder(manifest, path, exclude, null);
    }

    public static ClassFinder getManifestFinder(Manifest manifest, String path, Set<String> exclude, Attr attr) throws IOException {
        String mftCP;
        if (manifest != null && (mftCP = ClassFinderUtils.getManifestClassPath(manifest, path, attr)) != null) {
            exclude.add(path);
            return new ClasspathClassFinder2.ExistingScanningLimits(mftCP, exclude);
        }
        return null;
    }

    public static Manifest getManifest(ZipFile zipFile) throws IOException {
        ZipEntry mftEntry = zipFile.getEntry(MANIFEST_ENTRY);
        Manifest mft = null;
        InputStream manFileStream = null;
        if (mftEntry != null) {
            try {
                manFileStream = zipFile.getInputStream(mftEntry);
                mft = new Manifest(manFileStream);
            }
            catch (IOException ioe) {
                IOException newIOE = new IOException(ioe.getMessage() + " while processing Manifest entry of Zip File: " + zipFile.getName());
                throw newIOE;
            }
            catch (RuntimeException re) {
                RuntimeException newRE = new RuntimeException(re.getMessage() + " while processing Manifest entry of Zip File: " + zipFile.getName(), re.getCause());
                throw newRE;
            }
        }
        if (manFileStream != null) {
            manFileStream.close();
        }
        return mft;
    }

    public static ClassFinder getManifestFinder(ZipFile zipFile, Set<String> exclude) throws IOException {
        return ClassFinderUtils.getManifestFinder(zipFile, exclude, null);
    }

    public static ClassFinder getManifestFinder(ZipFile zipFile, Set<String> exclude, Attr attr) throws IOException {
        return ClassFinderUtils.getManifestFinder(ClassFinderUtils.getManifest(zipFile), zipFile.getName(), exclude, attr);
    }

    private static String getManifestClassPath(Manifest mft, String fName, Attr attr) {
        Attributes mainAttributes;
        if (mft != null && (mainAttributes = mft.getMainAttributes()) != null) {
            StringBuffer optPackCP;
            String cpAttr;
            StringBuffer ret = null;
            if ((attr == null || attr == Attr.CLASS_PATH) && (cpAttr = (String)mainAttributes.get(Attributes.Name.CLASS_PATH)) != null) {
                ret = ClassFinderUtils.convertManifestClassPath(fName, cpAttr);
            }
            if ((attr == null || attr == Attr.EXTENSION_LIST) && (optPackCP = ClassFinderUtils.getOptionalPackages(fName, mainAttributes)) != null) {
                if (ret == null) {
                    ret = optPackCP;
                } else {
                    ret.append(File.pathSeparatorChar).append(optPackCP);
                }
            }
            if (ret != null) {
                return ret.toString();
            }
        }
        return null;
    }

    private static StringBuffer getOptionalPackages(String src, Attributes attrs) {
        OptionalPackageProvider provider = OptionalPackageProvider.get();
        if (provider == null) {
            return null;
        }
        File[] f = provider.getOptionalPackages(src, attrs);
        if (f == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < f.length; ++i) {
            ret.append(f[i].getAbsolutePath());
            if (i >= f.length - 1) continue;
            ret.append(File.pathSeparatorChar);
        }
        return ret;
    }

    private static StringBuffer convertManifestClassPath(String fileName, String mftCP) {
        StringBuffer ret = new StringBuffer();
        int lastSep = fileName.lastIndexOf(File.separatorChar);
        String relPath = "";
        if (lastSep > -1) {
            relPath = fileName.substring(0, lastSep + 1);
        }
        String[] cp = StringUtils.splitCompletely(mftCP, " " + File.pathSeparatorChar);
        for (int i = 0; i < cp.length; ++i) {
            if (cp[i].startsWith(BEA_HOME_PLACEHOLDER)) {
                String home = BeaHomeHolder.getBeaHome();
                if (home == null) {
                    throw new AssertionError((Object)"Can't get BEA home directory path");
                }
                ret.append(home);
                ret.append(cp[i].substring(BEA_HOME_PLACEHOLDER.length(), cp[i].length()).replace('/', File.separatorChar));
            } else {
                ret.append(relPath);
                cp[i] = cp[i].replace('/', File.separatorChar);
                ret.append(cp[i]);
            }
            if (i >= cp.length - 1) continue;
            ret.append(File.pathSeparatorChar);
        }
        return ret;
    }

    public static boolean isShareable(Manifest manifest) {
        Attributes attrs;
        if (manifest != null && (attrs = manifest.getMainAttributes()) != null) {
            return Boolean.valueOf(attrs.getValue(SHAREABLE_MANIFEST_ATTR_NAME));
        }
        return false;
    }

    public static void checkArchive(String path, Exception ioe) {
        if (!ClassLoaderDebugger.checkArchive()) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String lastModified = df.format(new Date(new File(path).lastModified()));
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = bis.read(buf, 0, 1024)) != -1) {
                md.update(buf, 0, len);
            }
            byte[] result = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < result.length; ++i) {
                sb.append(String.format("%02x", result[i]));
            }
            ClassLoadersLogger.foundCorruptedJarFile(path, sb.toString(), lastModified, ioe);
        }
        catch (NoSuchAlgorithmException e1) {
            ClassLoadersLogger.foundCorruptedJarFile(path, "<failed to calculate due to no SHA-256 component>", lastModified, ioe);
        }
        catch (IOException e2) {
            ClassLoadersLogger.foundCorruptedJarFile(path, "<failed to calculate due to IOException>" + e2.toString(), lastModified, ioe);
        }
    }

    public static final class Attr {
        public static final Attr CLASS_PATH = new Attr();
        public static final Attr EXTENSION_LIST = new Attr();

        private Attr() {
        }
    }
}

