/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Enumeration;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.debug.ClassLoaderDebugger;
import weblogic.utils.classloaders.debug.SupportedClassLoader;
import weblogic.utils.collections.ConcurrentHashMap;

public class ChangeAwareClassLoader
extends GenericClassLoader {
    private final ConcurrentHashMap<String, Long> modTimes = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<?>> cachedClasses = new ConcurrentHashMap();
    private volatile long lastChecked;
    private volatile boolean upToDate = true;
    private volatile boolean childFirst;
    private static final DebugLogger vDebugLogger;
    private static final DebugLogger ctDebugLogger;

    public ChangeAwareClassLoader(ClassFinder finder, boolean childFirst, ClassLoader parent) {
        super(finder, parent);
        this.childFirst = childFirst;
        this.lastChecked = System.currentTimeMillis();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.CACL, "loadClass", name);
        }
        try {
            return this.loadClass(name, false);
        }
        catch (Error e) {
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> res = this.cachedClasses.get(name);
            if (res != null) {
                return res;
            }
            if (!this.childFirst) {
                return super.loadClass(name, resolve);
            }
            if (name.startsWith("java.") || name.startsWith("javax.") && !name.startsWith("javax.xml") && !name.startsWith("javax.wsdl") || name.startsWith("weblogic.") || name.startsWith("com.sun.org.")) {
                return super.loadClass(name, resolve);
            }
            try {
                Class clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException cnfe) {
                return super.loadClass(name, resolve);
            }
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> res;
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.CACL, "findClass", name);
        }
        if ((res = this.cachedClasses.get(name)) != null) {
            return res;
        }
        if (beVerbose) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.CACL, "findClass", name, "About to loadClass", new Object[0]);
        }
        try {
            res = super.findClass(name);
        }
        catch (Error e) {
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (doTrace) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, e);
            }
            throw e;
        }
        this.cachedClasses.put(name, res);
        Source source = this.getClassFinder().getClassSource(name);
        if (source != null) {
            long lastMod = source.lastModified();
            this.modTimes.put(res.getName(), new Long(lastMod));
        }
        return res;
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    public void forceToBounce() {
        this.upToDate = false;
    }

    public boolean upToDate() {
        if (!this.upToDate) {
            return false;
        }
        this.lastChecked = System.currentTimeMillis();
        for (String name : this.modTimes.keySet()) {
            long oldModtime = this.modTimes.get(name);
            Source source = this.getClassFinder().getClassSource(name);
            if (source == null) {
                return true;
            }
            long currentModtime = source.lastModified();
            if (currentModtime == oldModtime) continue;
            this.upToDate = false;
            return false;
        }
        return true;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        boolean beVerbose = vDebugLogger.isDebugEnabled();
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.CACL, "getResource", name);
        }
        try {
            if (!this.childFirst) {
                url = this.getSuperResource(name);
            } else {
                url = this.findResource(name);
                if (url == null) {
                    url = this.getSuperResource(name);
                }
            }
        }
        catch (AccessControlException e) {
            if (beVerbose) {
                ClassLoaderDebugger.verbose(this, SupportedClassLoader.CACL, "getResource", name, "Resource does not seem to be visible in this security context", e.getMessage());
            }
            url = null;
        }
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.CACL, "getResource", name, url);
            if (url == null) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, name);
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        boolean doTrace = ctDebugLogger.isDebugEnabled();
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.CACL, "getResources", name);
        }
        if (!this.childFirst) {
            return super.getResources(name);
        }
        Enumeration<URL> urls = this.compound(this.findResources(name), this.getParentResources(name));
        if (doTrace) {
            ClassLoaderDebugger.debug(this, SupportedClassLoader.CACL, "getResources", name, urls);
            if (urls == null) {
                ClassLoaderDebugger.debug((GenericClassLoader)this, name);
            }
        }
        return urls;
    }

    protected URL getSuperResource(String name) {
        return super.getResource(name);
    }

    public boolean isChildFirst() {
        return this.childFirst;
    }

    public void setChildFirst(boolean val) {
        this.childFirst = val;
        if (vDebugLogger.isDebugEnabled()) {
            ClassLoaderDebugger.verbose(this, SupportedClassLoader.CACL, "setChildFirst", Boolean.toString(val), "Set preferWebInfClasses to ", Boolean.toString(val));
        }
    }

    @Override
    public String getClassPath() {
        if (!this.childFirst) {
            return super.getClassPath();
        }
        StringBuilder sb = new StringBuilder();
        String finderClasspath = this.getFinderClassPath();
        if (finderClasspath != null && !finderClasspath.equals("")) {
            sb.append(finderClasspath);
        }
        this.getParentClassPath(sb);
        return sb.toString();
    }

    static {
        ClassLoader.registerAsParallelCapable();
        vDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingVerbose");
        ctDebugLogger = DebugLogger.getDebugLogger("DebugClassLoadingContextualTrace");
    }
}

