/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classloaders;

import java.util.Enumeration;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.SingleItemEnumeration;

public abstract class AbstractClassFinder
implements ClassFinder {
    public static final char[] CLASS_ARRAY = new char[]{'.', 'c', 'l', 'a', 's', 's'};

    @Override
    public Enumeration<Source> getSources(String name) {
        Source s = this.getSource(name);
        if (s == null) {
            return new EmptyEnumerator<Source>();
        }
        return new SingleItemEnumeration<Source>(s);
    }

    @Override
    public Source getClassSource(String name) {
        int nameLength = name.length();
        char[] newChars = new char[nameLength + CLASS_ARRAY.length];
        name.getChars(0, nameLength, newChars, 0);
        for (int i = 0; i < nameLength; ++i) {
            if (newChars[i] != '.') continue;
            newChars[i] = 47;
        }
        System.arraycopy(CLASS_ARRAY, 0, newChars, nameLength, CLASS_ARRAY.length);
        return this.getSource(StringUtils.getString(newChars, 0, newChars.length));
    }

    @Override
    public ClassFinder getManifestFinder() {
        return null;
    }

    @Override
    public Enumeration<Source> entries() {
        return EmptyEnumerator.getEmptyEnumerator();
    }

    @Override
    public void freeze() {
    }

    @Override
    public void close() {
    }
}

