/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import weblogic.utils.classfile.BadBytecodesException;
import weblogic.utils.classfile.Bytecodes;
import weblogic.utils.classfile.Label;
import weblogic.utils.classfile.Op;
import weblogic.utils.classfile.ops.Resolvable;

public class BranchOp
extends Op
implements Resolvable {
    public Op target;
    public int offset;

    public BranchOp(int op_code) {
        super(op_code);
    }

    public BranchOp(int op_code, int offset) {
        super(op_code);
        this.offset = offset;
    }

    public BranchOp(int op_code, Label target) {
        super(op_code);
        this.target = target;
    }

    @Override
    public String toString() {
        return super.toString() + " offset = " + this.offset;
    }

    @Override
    public boolean resolve(Bytecodes code) throws BadBytecodesException {
        int pc = code.pcForOp(this);
        if (this.target == null) {
            this.target = code.opAtPC(pc + this.offset);
        } else {
            this.offset = code.pcForOp(this.target) - pc;
        }
        if (this.op_code == 200 && !this.wideOffset()) {
            this.op_code = 167;
            return true;
        }
        if (this.op_code == 201 && !this.wideOffset()) {
            this.op_code = 168;
            return true;
        }
        return false;
    }

    private boolean wideOffset() {
        return this.offset > Short.MAX_VALUE || this.offset < Short.MIN_VALUE;
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.offset = this.op_code == 200 || this.op_code == 201 ? in.readInt() : (int)in.readShort();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.op_code);
        if (this.op_code == 200 || this.op_code == 201) {
            out.writeInt(this.offset);
        } else {
            out.writeShort(this.offset);
        }
    }
}

