/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile.expr;

import weblogic.utils.Debug;
import weblogic.utils.classfile.Bytecodes;
import weblogic.utils.classfile.CodeAttribute;
import weblogic.utils.classfile.Label;
import weblogic.utils.classfile.Type;
import weblogic.utils.classfile.expr.ConditionalExpression;
import weblogic.utils.classfile.expr.Expression;
import weblogic.utils.classfile.ops.BranchOp;

public class NotNullCondExpression
implements ConditionalExpression {
    Expression ref;

    public NotNullCondExpression(Expression ref) {
        Debug.assertion(ref.getType() == Type.OBJECT || ref.getType() == Type.ARRAY);
        this.ref = ref;
    }

    @Override
    public void code(CodeAttribute ca, Bytecodes code) {
        this.ref.code(ca, code);
    }

    @Override
    public void codeConditional(CodeAttribute ca, Bytecodes code, Label falseLabel) {
        this.ref.code(ca, code);
        code.add(new BranchOp(198, falseLabel));
    }

    @Override
    public Type getType() {
        return Type.BOOLEAN;
    }

    @Override
    public int getMaxStack() {
        return 1;
    }
}

