/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile.expr;

import weblogic.utils.classfile.Bytecodes;
import weblogic.utils.classfile.CodeAttribute;
import weblogic.utils.classfile.Scope;
import weblogic.utils.classfile.Type;
import weblogic.utils.classfile.expr.Expression;
import weblogic.utils.classfile.expr.LHSExpression;

public class LocalVariableExpression
implements LHSExpression {
    public Scope.LocalVar var;
    public Scope scope;

    public LocalVariableExpression(Scope scope, Scope.LocalVar var) {
        this.scope = scope;
        this.var = var;
    }

    @Override
    public void code(CodeAttribute ca, Bytecodes code) {
        code.add(this.var.getLoadOp());
    }

    @Override
    public void codeAssign(CodeAttribute ca, Bytecodes code, Expression val) {
        if (val.getType() != this.var.getType()) {
            throw new AssertionError((Object)("invalid assignment from '" + val.getType() + "' to '" + this.var.getType() + "'"));
        }
        val.code(ca, code);
        code.add(this.var.getStoreOp());
    }

    Scope.LocalVar getLocalVar() {
        return this.var;
    }

    @Override
    public Type getType() {
        if (this.var == null) {
            return Type.INVALID;
        }
        return this.var.getType();
    }

    public int getIndex() {
        return this.var.getIndex();
    }

    @Override
    public int getMaxStack() {
        return this.getType().isWide() ? 2 : 1;
    }

    public void free() {
        this.scope.freeLocalVar(this);
    }
}

