/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile.expr;

import weblogic.utils.classfile.Bytecodes;
import weblogic.utils.classfile.CodeAttribute;
import weblogic.utils.classfile.Type;
import weblogic.utils.classfile.cp.CPInterfaceMethodref;
import weblogic.utils.classfile.cp.CPMemberType;
import weblogic.utils.classfile.cp.CPMethodref;
import weblogic.utils.classfile.cp.ConstantPool;
import weblogic.utils.classfile.expr.Expression;
import weblogic.utils.classfile.expr.Utilities;
import weblogic.utils.classfile.ops.ConstPoolOp;
import weblogic.utils.classfile.ops.InvokeInterfaceOp;

public class InvokeExpression
implements Expression {
    Expression ref;
    CPMemberType meth;
    Expression[] args;

    public InvokeExpression(CPMemberType meth, Expression ref, Expression[] args) {
        this.ref = ref;
        this.meth = meth;
        this.args = args;
    }

    @Override
    public void code(CodeAttribute ca, Bytecodes code) {
        ConstantPool cp = ca.getConstantPool();
        this.ref.code(ca, code);
        int argsSize = 1;
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].code(ca, code);
            argsSize += this.args[i].getType().isWide() ? 2 : 1;
        }
        if (this.meth instanceof CPInterfaceMethodref) {
            code.add(new InvokeInterfaceOp(185, cp, (CPInterfaceMethodref)this.meth, argsSize));
        } else if (this.meth instanceof CPMethodref) {
            code.add(new ConstPoolOp(182, cp, this.meth));
        } else {
            throw new AssertionError((Object)("Unknown method type used in invoke: " + this.meth.getClass().getName()));
        }
    }

    @Override
    public Type getType() {
        return Utilities.getReturnType(this.meth.getDescriptor());
    }

    @Override
    public int getMaxStack() {
        int argsMax = this.ref.getType().isWide() ? 2 : 1;
        int computeMax = this.ref.getMaxStack();
        for (Expression e : this.args) {
            if (argsMax + e.getMaxStack() > computeMax) {
                computeMax = argsMax + e.getMaxStack();
            }
            argsMax += e.getType().isWide() ? 2 : 1;
        }
        int retStack = this.getType().isWide() ? 2 : 1;
        return Math.max(Math.max(argsMax, computeMax), retStack);
    }
}

