/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile;

import java.lang.reflect.Method;
import java.util.LinkedList;
import weblogic.utils.classfile.Op;
import weblogic.utils.classfile.Type;
import weblogic.utils.classfile.expr.Expression;
import weblogic.utils.classfile.expr.LocalVariableExpression;
import weblogic.utils.classfile.ops.LocalVarOp;

public class Scope {
    private int maxLocals = 0;
    private LocalVar[] localVars = new LocalVar[2];
    private Expression[] args;

    public Scope(Method method, int modifiers) {
        this.init(modifiers);
        Class<?>[] paramTypes = method.getParameterTypes();
        int length = paramTypes.length;
        this.args = new Expression[length];
        for (int i = 0; i < length; ++i) {
            this.args[i] = new LocalVariableExpression(this, this.allocLocalVar(Type.getType(paramTypes[i])));
        }
    }

    public Scope(String descriptor, int modifiers) {
        this.init(modifiers);
        Type[] paramTypes = this.getParamTypes(descriptor);
        int length = paramTypes.length;
        this.args = new Expression[length];
        for (int i = 0; i < length; ++i) {
            this.args[i] = new LocalVariableExpression(this, this.allocLocalVar(paramTypes[i]));
        }
    }

    private void init(int modifiers) {
        boolean isStatic;
        boolean bl = isStatic = (modifiers & 8) == 8;
        if (!isStatic) {
            this.allocLocalVar(Type.OBJECT);
        }
    }

    private void badDescriptor(String descriptor) {
        throw new AssertionError((Object)("Invalid descriptor: " + descriptor));
    }

    private Type[] getParamTypes(String descriptor) {
        try {
            int i;
            if (descriptor.charAt(0) != '(') {
                this.badDescriptor(descriptor);
            }
            if ((i = descriptor.indexOf(41)) == -1) {
                this.badDescriptor(descriptor);
            }
            return this.getTypes(descriptor, 1, i);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.badDescriptor(descriptor);
            return null;
        }
    }

    private Type[] getTypes(String descriptor, int startIndex, int endIndex) {
        LinkedList<Type> types = new LinkedList<Type>();
        block13: for (int i = startIndex; i < endIndex; ++i) {
            switch (descriptor.charAt(i)) {
                case 'I': {
                    types.add(Type.INT);
                    continue block13;
                }
                case 'B': {
                    types.add(Type.BYTE);
                    continue block13;
                }
                case 'Z': {
                    types.add(Type.BOOLEAN);
                    continue block13;
                }
                case 'S': {
                    types.add(Type.SHORT);
                    continue block13;
                }
                case 'F': {
                    types.add(Type.FLOAT);
                    continue block13;
                }
                case 'C': {
                    types.add(Type.CHARACTER);
                    continue block13;
                }
                case 'J': {
                    types.add(Type.LONG);
                    continue block13;
                }
                case 'D': {
                    types.add(Type.DOUBLE);
                    continue block13;
                }
                case 'V': {
                    types.add(Type.VOID);
                    continue block13;
                }
                case 'L': {
                    types.add(Type.OBJECT);
                    while (i < endIndex && descriptor.charAt(i) != ';') {
                        ++i;
                    }
                    if (descriptor.charAt(i) == ';') continue block13;
                    this.badDescriptor(descriptor);
                    continue block13;
                }
                case '[': {
                    char c;
                    types.add(Type.ARRAY);
                    while (i < endIndex && descriptor.charAt(i) == '[') {
                        ++i;
                    }
                    if (i == endIndex) {
                        this.badDescriptor(descriptor);
                    }
                    if ((c = descriptor.charAt(i)) == 'V') {
                        this.badDescriptor(descriptor);
                    }
                    if (c == 'I' || c == 'B' || c == 'Z' || c == 'S' || c == 'F' || c == 'C' || c == 'J' || c == 'D') continue block13;
                    if (c != 'L') {
                        this.badDescriptor(descriptor);
                    }
                    while (i < endIndex && descriptor.charAt(i) != ';') {
                        ++i;
                    }
                    if (descriptor.charAt(i) == ';') continue block13;
                    this.badDescriptor(descriptor);
                }
            }
        }
        return types.toArray(new Type[types.size()]);
    }

    public Expression getParameter(int i) {
        return this.args[i - 1];
    }

    public Expression[] getArgs() {
        return this.args;
    }

    LocalVar allocLocalVar(Type type) {
        LocalVar var = new LocalVar(type);
        int endIndex = this.localVars.length - (var.isWide() ? 1 : 0);
        for (int i = 0; i < endIndex; ++i) {
            if (this.localVars[i] != null) continue;
            if (!var.isWide()) {
                this.localVars[i] = var;
                var.setIndex(i);
                if (i + 1 > this.maxLocals) {
                    this.maxLocals = i + 1;
                }
                return var;
            }
            if (this.localVars[i + 1] != null) continue;
            LocalVar localVar = var;
            this.localVars[i + 1] = localVar;
            this.localVars[i] = localVar;
            var.setIndex(i);
            if (i + 2 > this.maxLocals) {
                this.maxLocals = i + 2;
            }
            return var;
        }
        int len = this.localVars.length;
        LocalVar[] tmp = new LocalVar[len * 2];
        System.arraycopy(this.localVars, 0, tmp, 0, len);
        this.localVars = tmp;
        if (var.isWide()) {
            if (this.localVars[len - 1] == null) {
                --len;
            }
            LocalVar localVar = var;
            this.localVars[len + 1] = localVar;
            this.localVars[len] = localVar;
            var.setIndex(len);
            if (len + 2 > this.maxLocals) {
                this.maxLocals = len + 2;
            }
            return var;
        }
        this.localVars[len] = var;
        var.setIndex(len);
        if (len + 1 > this.maxLocals) {
            this.maxLocals = len + 1;
        }
        return var;
    }

    public LocalVariableExpression createLocalVar(Type t) {
        return new LocalVariableExpression(this, this.allocLocalVar(t));
    }

    public void freeLocalVar(LocalVariableExpression lve) {
        if (lve.var != null) {
            this.localVars[lve.var.index] = null;
            if (lve.var.isWide()) {
                this.localVars[lve.var.index + 1] = null;
            }
        }
    }

    int getMaxLocals() {
        return this.maxLocals;
    }

    public static class LocalVar {
        Type type;
        int index;
        int loadOpCode;
        int loadOpCode0;
        int storeOpCode;
        int storeOpCode0;

        public LocalVar(Type type) {
            this.type = type;
            if (type == Type.OBJECT || type == Type.ARRAY) {
                this.loadOpCode = 25;
                this.loadOpCode0 = 42;
                this.storeOpCode = 58;
                this.storeOpCode0 = 75;
            } else if (type == Type.INT || type == Type.BYTE || type == Type.BOOLEAN || type == Type.SHORT || type == Type.CHARACTER) {
                this.loadOpCode = 21;
                this.loadOpCode0 = 26;
                this.storeOpCode = 54;
                this.storeOpCode0 = 59;
            } else if (type == Type.LONG) {
                this.loadOpCode = 22;
                this.loadOpCode0 = 30;
                this.storeOpCode = 55;
                this.storeOpCode0 = 63;
            } else if (type == Type.FLOAT) {
                this.loadOpCode = 23;
                this.loadOpCode0 = 34;
                this.storeOpCode = 56;
                this.storeOpCode0 = 67;
            } else if (type == Type.DOUBLE) {
                this.loadOpCode = 24;
                this.loadOpCode0 = 38;
                this.storeOpCode = 57;
                this.storeOpCode0 = 71;
            } else {
                throw new AssertionError((Object)("Unknown type: " + type));
            }
        }

        public int getIndex() {
            return this.index;
        }

        void setIndex(int index) {
            this.index = index;
        }

        boolean isWide() {
            return this.type == Type.LONG || this.type == Type.DOUBLE;
        }

        public Op getStoreOp() {
            if (this.index > 3) {
                return new LocalVarOp(this.storeOpCode, this.index);
            }
            return new Op(this.storeOpCode0 + this.index);
        }

        public Op getLoadOp() {
            if (this.index > 3) {
                return new LocalVarOp(this.loadOpCode, this.index);
            }
            return new Op(this.loadOpCode0 + this.index);
        }

        public Op getReturnOp() {
            return new LocalVarOp(169, this.index);
        }

        public Type getType() {
            return this.type;
        }
    }
}

