/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import weblogic.utils.classfile.BadBytecodesException;
import weblogic.utils.classfile.ClassFile;
import weblogic.utils.classfile.ClassMember;
import weblogic.utils.classfile.MethodInfo;

public class MethodTable {
    private static final boolean verbose = false;
    private ClassFile classFile;
    SortedSet<MethodInfo> methods = new TreeSet<MethodInfo>(new MethodComparator());

    public MethodTable(ClassFile classFile) {
        this.classFile = classFile;
    }

    public Iterator<MethodInfo> getMethods() {
        return this.methods.iterator();
    }

    public void addMethod(MethodInfo mi) {
        this.methods.add(mi);
    }

    public void read(DataInput in) throws IOException, BadBytecodesException {
        int size = in.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            MethodInfo method = new MethodInfo(this.classFile);
            method.read(in);
            this.methods.add(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput out) throws IOException, BadBytecodesException {
        SortedSet<MethodInfo> sortedSet = this.methods;
        synchronized (sortedSet) {
            Iterator i = this.methods.iterator();
            out.writeShort(this.methods.size());
            while (i.hasNext()) {
                ClassMember member = (ClassMember)i.next();
                member.write(out);
            }
        }
    }

    public void dump(PrintStream out) throws BadBytecodesException {
        out.println("methods: ...");
        Iterator i = this.methods.iterator();
        while (i.hasNext()) {
            ((ClassMember)i.next()).dump(out);
        }
    }

    public static void say(String s) {
        System.out.println(s);
    }

    private static class MethodComparator
    implements Comparator<MethodInfo> {
        private MethodComparator() {
        }

        @Override
        public int compare(MethodInfo m1, MethodInfo m2) {
            return m1.toString().compareTo(m2.toString());
        }
    }
}

