/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import weblogic.utils.classfile.BadBytecodesException;
import weblogic.utils.classfile.MalformedClassException;
import weblogic.utils.classfile.attribute_info;
import weblogic.utils.classfile.cp.CPClass;
import weblogic.utils.classfile.cp.ConstantPool;

public class Exceptions_attribute
extends attribute_info {
    public static final String NAME = "Exceptions";
    public int number_of_exceptions;
    public CPClass[] exception_table;

    public Exceptions_attribute() {
    }

    public Exceptions_attribute(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
        this.attribute_name = constant_pool.getUtf8(NAME);
    }

    public CPClass[] getExceptionTable() {
        return this.exception_table;
    }

    @Override
    public void read(DataInput in) throws IOException, BadBytecodesException {
        super.read(in);
        try {
            this.number_of_exceptions = in.readUnsignedShort();
            this.exception_table = new CPClass[this.number_of_exceptions];
            for (int i = 0; i < this.number_of_exceptions; ++i) {
                int idx = in.readUnsignedShort();
                this.exception_table[i] = idx == 0 ? null : this.constant_pool.classAt(idx);
            }
        }
        catch (MalformedClassException mce) {
            throw new IOException(String.valueOf(mce));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException, BadBytecodesException {
        this.attribute_length = 2 + 2 * this.number_of_exceptions;
        super.write(out);
        out.writeShort(this.number_of_exceptions);
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            if (this.exception_table[i] == null) {
                out.writeShort(0);
                continue;
            }
            out.writeShort(this.exception_table[i].getIndex());
        }
    }

    private static void say(String s) {
        System.out.println(s);
    }
}

