/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classfile;

import java.util.ArrayList;
import java.util.List;
import weblogic.utils.Debug;
import weblogic.utils.classfile.WrongDescriptorTypeException;

public final class Descriptor {
    private static final boolean debug = true;
    private static final boolean verbose = true;
    private String text;
    private boolean isMethodDesriptor;

    public Descriptor(String t) {
        this.text = t;
    }

    public boolean isFieldDesriptor() {
        return !this.isMethodDesriptor();
    }

    public boolean isMethodDesriptor() {
        return this.text.indexOf(40) != -1;
    }

    public String getFieldType() {
        if (!this.isFieldDesriptor()) {
            throw new WrongDescriptorTypeException("Not a field descriptor.");
        }
        return (String)Descriptor.parse(this.text).get(0);
    }

    public String getReturnType() {
        if (!this.isMethodDesriptor()) {
            throw new WrongDescriptorTypeException("Not a method descriptor.");
        }
        return (String)Descriptor.parse(this.text.substring(this.text.indexOf(41) + 1)).get(0);
    }

    public List getArgumentTypes() {
        if (!this.isMethodDesriptor()) {
            throw new WrongDescriptorTypeException("Not a method descriptor.");
        }
        int openP = this.text.indexOf(40);
        int closeP = this.text.indexOf(41);
        Debug.assertion(openP != -1 && closeP != -1);
        return Descriptor.parse(this.text.substring(openP + 1, closeP));
    }

    public static String getBaseType(String text) {
        int bracket = text.lastIndexOf(91);
        if (bracket == -1) {
            return text;
        }
        return text.substring(0, bracket);
    }

    public static String getClassType(String text) {
        if (text.startsWith("[")) {
            return (String)Descriptor.parse(text).get(0);
        }
        return text.replace('/', '.');
    }

    static List parse(String desc) {
        ArrayList<String> types = new ArrayList<String>();
        int arrayDim = 0;
        int len = desc.length();
        block13: for (int idx = 0; idx < len; ++idx) {
            switch (desc.charAt(idx)) {
                case '[': {
                    ++arrayDim;
                    continue block13;
                }
                case 'L': {
                    int semi = desc.indexOf(59, idx);
                    String type = desc.substring(idx + 1, semi);
                    type = type.replace('/', '.');
                    types.add(Descriptor.typeWithArray(type, arrayDim));
                    idx = semi;
                    break;
                }
                case 'B': {
                    types.add(Descriptor.typeWithArray("byte", arrayDim));
                    break;
                }
                case 'C': {
                    types.add(Descriptor.typeWithArray("char", arrayDim));
                    break;
                }
                case 'D': {
                    types.add(Descriptor.typeWithArray("double", arrayDim));
                    break;
                }
                case 'F': {
                    types.add(Descriptor.typeWithArray("float", arrayDim));
                    break;
                }
                case 'I': {
                    types.add(Descriptor.typeWithArray("int", arrayDim));
                    break;
                }
                case 'J': {
                    types.add(Descriptor.typeWithArray("long", arrayDim));
                    break;
                }
                case 'S': {
                    types.add(Descriptor.typeWithArray("short", arrayDim));
                    break;
                }
                case 'Z': {
                    types.add(Descriptor.typeWithArray("boolean", arrayDim));
                    break;
                }
                case 'V': {
                    types.add(Descriptor.typeWithArray("void", arrayDim));
                    break;
                }
                default: {
                    throw new Error("Bad descriptor: <" + desc + ">");
                }
            }
            arrayDim = 0;
        }
        return types;
    }

    private static String typeWithArray(String type, int arrayDim) {
        StringBuffer sb = new StringBuffer(type);
        for (int i = 0; i < arrayDim; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static boolean isPrimitive(String type) {
        String base = Descriptor.getBaseType(type);
        switch (base.charAt(0)) {
            case 'b': {
                if (!base.equals("boolean") && !base.equals("byte")) break;
                return true;
            }
            case 'c': {
                if (!base.equals("char")) break;
                return true;
            }
            case 'd': {
                if (!base.equals("double")) break;
                return true;
            }
            case 'f': {
                if (!base.equals("float")) break;
                return true;
            }
            case 'i': {
                if (!base.equals("int")) break;
                return true;
            }
            case 'l': {
                if (!base.equals("long")) break;
                return true;
            }
            case 's': {
                if (!base.equals("short")) break;
                return true;
            }
            case 'v': {
                if (!base.equals("void")) break;
                return true;
            }
        }
        return false;
    }

    public static int getArrayDimension(String type) {
        int dim = 0;
        int len = type.length();
        for (int i = 0; i < len && type.charAt(i) == '['; ++i) {
            ++dim;
        }
        return dim;
    }
}

