/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.classes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.utils.classes.ClassBytes;
import weblogic.utils.classes.ClassBytes102;
import weblogic.utils.classes.ClassBytes11;
import weblogic.utils.classes.ClassFinder102;

public class ClassFinder11
extends ClassFinder102 {
    private ZipFile[] zipFiles;

    public ClassFinder11() {
    }

    public ClassFinder11(String path) {
        super(path);
    }

    public ClassFinder11(File[] classpath) {
        super(classpath);
    }

    @Override
    protected void zipScan() {
        int i;
        for (i = 0; this.zipFiles != null && i < this.zipFiles.length; ++i) {
            if (this.zipFiles[i] == null) continue;
            try {
                this.zipFiles[i].close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.zipScan();
        if (this.zips == null) {
            this.zipFiles = null;
            return;
        }
        this.zipFiles = new ZipFile[this.zips.length];
        for (i = 0; i < this.zipFiles.length; ++i) {
            if (!this.zips[i]) continue;
            try {
                this.zipFiles[i] = new ZipFile(this.classpath[i]);
                continue;
            }
            catch (IOException e) {
                this.zips[i] = false;
            }
        }
    }

    @Override
    public InputStream getResourceStream(String resource) throws IOException {
        resource = resource.replace('/', File.separatorChar);
        String zipRsc = resource.replace(File.separatorChar, '/');
        for (int i = 0; i < this.classpath.length; ++i) {
            ZipEntry ze;
            if (this.classpath[i].isDirectory()) {
                File f = new File(this.classpath[i], resource);
                if (!f.exists()) continue;
                return new FileInputStream(f);
            }
            if (this.zipFiles[i] == null || (ze = this.zipFiles[i].getEntry(zipRsc)) == null) continue;
            return this.zipFiles[i].getInputStream(ze);
        }
        throw new FileNotFoundException(resource);
    }

    @Override
    public ClassBytes find(String clss) {
        String zipName = clss.replace('.', '/') + ".class";
        clss = clss.replace('.', File.separatorChar) + ".class";
        for (int i = 0; i < this.classpath.length; ++i) {
            ZipEntry ent;
            if (this.classpath[i].isDirectory()) {
                File f = new File(this.classpath[i], clss);
                if (!f.exists()) continue;
                return new ClassBytes102(f, this.classpath[i]);
            }
            if (this.zipFiles[i] == null || (ent = this.zipFiles[i].getEntry(zipName)) == null) continue;
            return new ClassBytes11(ent, this.zipFiles[i]);
        }
        return null;
    }

    public void finalize() {
        for (int i = 0; this.zipFiles != null && i < this.zipFiles.length; ++i) {
            if (this.zipFiles[i] == null) continue;
            try {
                this.zipFiles[i].close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

