/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XXEUtils {
    private static final String NOT_SUPPORTED = "External entities not supported";
    private static final String SAX_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String SAX_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String XERCES2_EXTERNAL_GENERAL_ENTITIES = "http://xerces.apache.org/xerces2-j/features.html#external-general-entities";
    private static final String XERCES2_EXTERNAL_PARAMETER_ENTITIES = "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities";
    private static final String XERCES1_EXTERNAL_GENERAL_ENTITIES = "http://xerces.apache.org/xerces-j/features.html#external-general-entities";
    private static final String XERCES1_EXTERNAL_PARAMETER_ENTITIES = "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities";

    private XXEUtils() {
    }

    public static Validator createValidator(Schema schema) {
        if (schema == null) {
            return null;
        }
        Validator validator = schema.newValidator();
        try {
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return validator;
    }

    public static XMLInputFactory createXMLInputFactoryInstance() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return factory;
    }

    public static XMLReader createXMLReader() throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        try {
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            reader.setFeature(SAX_EXTERNAL_GENERAL_ENTITIES, false);
            reader.setFeature(SAX_EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            reader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    throw new SAXException(XXEUtils.NOT_SUPPORTED);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return reader;
    }

    public static SAXParserFactory createSAXParserFactoryInstance() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Throwable ignore) {
            try {
                factory.setFeature(SAX_EXTERNAL_GENERAL_ENTITIES, false);
                factory.setFeature(SAX_EXTERNAL_PARAMETER_ENTITIES, false);
            }
            catch (Throwable ignore2) {
                try {
                    factory.setFeature(XERCES2_EXTERNAL_GENERAL_ENTITIES, false);
                    factory.setFeature(XERCES2_EXTERNAL_PARAMETER_ENTITIES, false);
                }
                catch (Throwable ignore3) {
                    try {
                        factory.setFeature(XERCES1_EXTERNAL_GENERAL_ENTITIES, false);
                        factory.setFeature(XERCES1_EXTERNAL_PARAMETER_ENTITIES, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return factory;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactoryInstance() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        XXEUtils.disableXXEOnDocumentBuilderFactory(factory);
        return factory;
    }

    public static void disableXXEOnDocumentBuilderFactory(DocumentBuilderFactory factory) {
        if (factory == null) {
            return;
        }
        try {
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Throwable ignore) {
            try {
                factory.setFeature(SAX_EXTERNAL_GENERAL_ENTITIES, false);
                factory.setFeature(SAX_EXTERNAL_PARAMETER_ENTITIES, false);
            }
            catch (Throwable ignore2) {
                try {
                    factory.setFeature(XERCES2_EXTERNAL_GENERAL_ENTITIES, false);
                    factory.setFeature(XERCES2_EXTERNAL_PARAMETER_ENTITIES, false);
                }
                catch (Throwable ignore3) {
                    try {
                        factory.setFeature(XERCES1_EXTERNAL_GENERAL_ENTITIES, false);
                        factory.setFeature(XERCES1_EXTERNAL_PARAMETER_ENTITIES, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static TransformerFactory createTransformerFactoryInstance() throws TransformerFactoryConfigurationError {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return factory;
    }
}

