/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import javax.transaction.xa.XAException;

public class XAUtils {
    public static String appendOracleXAResourceInfo(XAException rootException, String msg) {
        msg = msg + XAUtils.appendOracleXAResourceInfo(rootException);
        return msg;
    }

    public static String appendOracleXAResourceInfo(XAException rootException) {
        String msg = rootException.getClass().getName() + ": ";
        if (rootException.getMessage() != null) {
            msg = msg + rootException.getMessage() + ": ";
        }
        String defaultMsg = msg + "XAException errorCode = " + rootException.errorCode;
        Class<?> aClass = rootException.getClass();
        if (aClass.getName().indexOf("OracleXAException") < 0) {
            return defaultMsg;
        }
        try {
            Object oracleError = XAUtils.invokeMethod(rootException, aClass, "getOracleError");
            Object oracleSQLError = XAUtils.invokeMethod(rootException, aClass, "getOracleSQLError");
            Object xaError = XAUtils.invokeMethod(rootException, aClass, "getXAError");
            msg = msg + "OracleError = " + oracleError + "; OracleSQLError = " + oracleSQLError + "; XAError = " + xaError;
        }
        catch (Exception e) {
            return defaultMsg;
        }
        return msg;
    }

    private static Object invokeMethod(XAException rootException, Class<? extends XAException> aClass, String methodName) {
        try {
            return aClass.getMethod(methodName, new Class[0]).invoke((Object)rootException, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

