/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.Dictionary;
import java.util.Map;
import weblogic.utils.StringUtils;

public final class TypeConversionUtils {
    private TypeConversionUtils() {
    }

    public static Dictionary stringToDictionary(String s, Dictionary d) {
        return TypeConversionUtils.stringToDictionary(s, d, ",");
    }

    public static Map stringToMap(String s, Map map) {
        return TypeConversionUtils.stringToMap(s, map, ",");
    }

    public static Dictionary stringToDictionary(String s, Dictionary d, String sep) {
        boolean escaped = false;
        if (s == null) {
            return d;
        }
        if (s.indexOf("=\"") == -1) {
            String[] st = StringUtils.splitCompletely(s, sep);
            for (int tok = st.length - 1; tok > -1; --tok) {
                String[] nvp = StringUtils.split(st[tok], '=');
                d.put(nvp[0], nvp[1]);
            }
        } else {
            String[] st = StringUtils.splitCompletely(s, sep, true);
            for (int tok = st.length - 1; tok > -1; tok -= 2) {
                String tk;
                if (st[tok].endsWith("\"")) {
                    String tkbuf = st[tok];
                    while (st[tok].indexOf("=\"") == -1) {
                        tkbuf = st[tok -= 2] + st[tok + 1] + tkbuf;
                    }
                    tk = tkbuf;
                    escaped = true;
                } else {
                    tk = st[tok];
                    escaped = false;
                }
                String[] nvp = StringUtils.split(tk, '=');
                if (escaped) {
                    d.put(nvp[0], nvp[1].substring(1, nvp[1].length() - 1));
                    continue;
                }
                d.put(nvp[0], nvp[1]);
            }
        }
        return d;
    }

    public static Map stringToMap(String s, Map map, String sep) {
        boolean escaped = false;
        if (s == null) {
            return map;
        }
        if (s.indexOf("=\"") == -1) {
            String[] st = StringUtils.splitCompletely(s, sep);
            for (int tok = st.length - 1; tok > -1; --tok) {
                String[] nvp = StringUtils.split(st[tok], '=');
                map.put(nvp[0], nvp[1]);
            }
        } else {
            String[] st = StringUtils.splitCompletely(s, sep, true);
            for (int tok = st.length - 1; tok > -1; tok -= 2) {
                String tk;
                if (st[tok].endsWith("\"")) {
                    String tkbuf = st[tok];
                    while (st[tok].indexOf("=\"") == -1) {
                        tkbuf = st[tok -= 2] + st[tok + 1] + tkbuf;
                    }
                    tk = tkbuf;
                    escaped = true;
                } else {
                    tk = st[tok];
                    escaped = false;
                }
                String[] nvp = StringUtils.split(tk, '=');
                if (escaped) {
                    map.put(nvp[0], nvp[1].substring(1, nvp[1].length() - 1));
                    continue;
                }
                map.put(nvp[0], nvp[1]);
            }
        }
        return map;
    }
}

