/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.BreakIterator;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import weblogic.utils.UnsyncStringBuffer;

public final class StringUtils {
    private static final StringMaker stringMaker;
    private static final int HI_BYTE = 0;
    private static final boolean USE_DEPRECATED = true;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String TYPE_ATT = "type";
    private static final String CTYPE_ATT = "Type";
    private static final String NAME_ATT = "name";
    private static final String CNAME_ATT = "Name";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String EQUALS = "=";

    private StringUtils() {
    }

    public static String[] split(String s, char delim) {
        String[] retVal = new String[]{s, ""};
        int dot = s.indexOf(delim);
        if (dot != -1) {
            retVal[0] = s.substring(0, dot);
            retVal[1] = s.substring(dot + 1);
        }
        return retVal;
    }

    public static String[] splitCompletely(String s, String delim, boolean returnDelim) {
        return StringUtils.splitCompletely(new StringTokenizer(s, delim, returnDelim));
    }

    public static String[] splitCompletely(String s, String delim) {
        return StringUtils.splitCompletely(new StringTokenizer(s, delim));
    }

    public static String[] splitCompletely(String s) {
        return StringUtils.splitCompletely(new StringTokenizer(s));
    }

    private static String[] splitCompletely(StringTokenizer stringTokenizer) {
        int i = stringTokenizer.countTokens();
        String[] st = new String[i];
        for (int j = 0; j < i; ++j) {
            st[j] = stringTokenizer.nextToken();
        }
        return st;
    }

    public static String[] splitPartially(String s, String delim, int limit) {
        String[] st;
        StringTokenizer stringTokenizer = new StringTokenizer(s, delim);
        int tokes = stringTokenizer.countTokens();
        if (limit == 0 || limit >= tokes) {
            st = new String[tokes];
            for (int j = 0; j < tokes; ++j) {
                st[j] = stringTokenizer.nextToken();
            }
        } else {
            st = new String[limit];
            for (int j = 0; j < limit - 1; ++j) {
                st[j] = stringTokenizer.nextToken();
            }
            st[j] = stringTokenizer.nextToken() + stringTokenizer.nextToken("");
        }
        return st;
    }

    public static String join(String[] ss, String delim) {
        if (ss == null) {
            ss = new String[]{};
        }
        return StringUtils.join(ss, delim, 0, ss.length);
    }

    public static String join(String[] ss, String delim, int start, int end) {
        if (ss == null) {
            ss = new String[]{};
        }
        int size = (end - start) * delim.length();
        for (int i = start; i < end; ++i) {
            size += ss[i].length();
        }
        StringBuilder buf = new StringBuilder(size);
        for (int i = start; i < end; ++i) {
            buf.append(ss[i]);
            if (i >= end - 1) continue;
            buf.append(delim);
        }
        return buf.toString();
    }

    public static String[] addStringAtIndex(String[] ss, String addMe, int index) {
        if (ss == null || addMe == null || index < 0 || index > ss.length) {
            throw new IllegalArgumentException("ss=" + Arrays.toString(ss) + " addMe=" + addMe + " index=" + index);
        }
        String[] retVal = new String[ss.length + 1];
        if (index > 0) {
            System.arraycopy(ss, 0, retVal, 0, index);
        }
        retVal[index] = addMe;
        if (index < ss.length) {
            System.arraycopy(ss, index, retVal, index + 1, ss.length - index);
        }
        return retVal;
    }

    public static int indexOfIgnoreCase(String s, String str) {
        return StringUtils.indexOfIgnoreCase(s, str, 0);
    }

    public static int indexOfIgnoreCase(String s, String str, int index) {
        int strLen = str.length();
        int regionLen = s.length() - strLen;
        for (int i = index; i <= regionLen; ++i) {
            if (!s.regionMatches(true, i, str, 0, strLen)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String s, String str) {
        return StringUtils.lastIndexOfIgnoreCase(s, str, 0);
    }

    public static int lastIndexOfIgnoreCase(String s, String str, int index) {
        for (int i = s.length() - str.length(); i >= index; --i) {
            if (!s.regionMatches(true, i, str, 0, str.length())) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWith(String s, char c) {
        return s.length() > 0 && s.charAt(0) == c;
    }

    public static boolean endsWith(String s, char c) {
        return s.length() > 0 && s.charAt(s.length() - 1) == c;
    }

    public static String upto(String s, char delim) {
        int dot = s.indexOf(delim);
        if (dot != -1) {
            return s.substring(0, dot);
        }
        return s;
    }

    public static String ucfirst(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String escapeString(String s) {
        UnsyncStringBuffer buf = new UnsyncStringBuffer(s.length());
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block10;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block10;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block10;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block10;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block10;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    buf.append("\\'");
                    continue block10;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block10;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String valueOf(int i) {
        boolean negative;
        char[] buf = new char[11];
        int index = buf.length;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -10) {
            buf[--index] = Character.forDigit(-(i % 10), 10);
            i /= 10;
        }
        buf[--index] = Character.forDigit(-i, 10);
        if (negative) {
            buf[--index] = 45;
        }
        return StringUtils.getString(buf, index, buf.length - index);
    }

    public static String valueOf(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static String valueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] data = new char[]{c};
        return new String(data);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String padStringWidth(String string, int width) {
        UnsyncStringBuffer buf;
        if (string != null) {
            int start;
            buf = new UnsyncStringBuffer(string);
            buf.setLength(width);
            for (int i = start = string.length(); i < width; ++i) {
                buf.setCharAt(i, ' ');
            }
        } else {
            buf = new UnsyncStringBuffer(width);
            for (int i = 0; i < width; ++i) {
                buf.setCharAt(i, ' ');
            }
        }
        return buf.toString();
    }

    public static String padStringWidth(int val, int width) {
        return StringUtils.padStringWidth(String.valueOf(val), width);
    }

    public static String padStringWidth(float val, int width) {
        return StringUtils.padStringWidth(String.valueOf(val), width);
    }

    public static String padStringWidth(long val, int width) {
        return StringUtils.padStringWidth(String.valueOf(val), width);
    }

    public static String padStringWidth(double val, int width) {
        return StringUtils.padStringWidth(String.valueOf(val), width);
    }

    public static String padNumberWidth(long val, int width) {
        UnsyncStringBuffer buf = new UnsyncStringBuffer(width);
        for (int index = width - 1; index >= 0; --index) {
            long place = (long)Math.pow(10.0, index);
            long num = val / place;
            buf.append(num);
            val -= num * place;
        }
        return buf.toString();
    }

    public static String replaceGlobal(String s, String subStr, String newSubStr) {
        int i;
        UnsyncStringBuffer buf = new UnsyncStringBuffer();
        int previ = 0;
        while ((i = s.indexOf(subStr, previ)) >= 0) {
            buf.append(s.substring(previ, i));
            buf.append(newSubStr);
            previ = i + subStr.length();
        }
        buf.append(s.substring(previ));
        return buf.toString();
    }

    public static boolean isEmptyString(String string) {
        return string == null || string.length() == 0 || StringUtils.isWhitespace(string);
    }

    public static boolean isWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String mangle(String input) {
        char[] chars = input.toCharArray();
        long hash = 0L;
        for (int i = 0; i < chars.length; ++i) {
            hash = 129L * hash + (long)chars[i];
        }
        return Long.toString(hash, 36);
    }

    public static String formatLines(String target, int maxLength, Locale currentLocale) {
        StringBuffer theResult = new StringBuffer();
        BreakIterator boundary = BreakIterator.getLineInstance(currentLocale);
        boundary.setText(target);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = 0;
        while (end != -1) {
            String word = target.substring(start, end);
            if ((lineLength += word.length()) >= maxLength) {
                theResult.append("\n");
                lineLength = word.length();
            }
            theResult.append(word);
            if (word.indexOf("\n") >= 0) {
                lineLength = 0;
            }
            start = end;
            end = boundary.next();
        }
        return new String(theResult);
    }

    public static int getUTFLength(String s) {
        int utflen = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static String getString(byte[] b) {
        return StringUtils.getString(b, 0, b.length);
    }

    public static String getString(byte[] b, int offset, int length) {
        return new String(b, 0, offset, length);
    }

    public static void getBytes(String str, int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        for (int current = srcBegin; current < srcEnd; ++current) {
            char c = str.charAt(current);
            dst[dstBegin++] = c > '\u00ff' ? 63 : (byte)c;
        }
    }

    public static String getString(char[] buf, int off, int len) {
        return stringMaker.getString(buf, off, len);
    }

    public static boolean strcmp(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static int compare(String str1, String str2) {
        if (str1 == null) {
            return str2 == null ? 0 : -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public static String constructOrderedObjectName(String domain, Map<String, String> attributes) {
        StringBuffer sb = new StringBuffer(domain);
        if (attributes == null || attributes.size() <= 0) {
            return sb.toString();
        }
        sb.append(COLON);
        String typeKey = TYPE_ATT;
        String typeValue = attributes.remove(TYPE_ATT);
        if (typeValue == null) {
            typeKey = CTYPE_ATT;
            typeValue = attributes.remove(CTYPE_ATT);
        }
        String nameKey = NAME_ATT;
        String nameValue = attributes.remove(NAME_ATT);
        if (nameValue == null) {
            nameKey = CNAME_ATT;
            nameValue = attributes.remove(CNAME_ATT);
        }
        if (typeValue != null) {
            sb.append(typeKey + EQUALS + typeValue);
            if (nameValue != null) {
                sb.append(COMMA);
            }
        }
        if (nameValue != null) {
            sb.append(nameKey + EQUALS + nameValue);
        }
        if ((typeValue != null || nameValue != null) && attributes.size() > 0) {
            sb.append(COMMA);
        }
        boolean firstOne = true;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(COMMA);
            }
            sb.append(key + EQUALS + value);
        }
        return sb.toString();
    }

    public static final String formatCurrentTimeFromNanoToMillis(long nanoSecond) {
        return StringUtils.formatCurrentTimeFromNanoToMillis(nanoSecond, "");
    }

    public static final String formatCurrentTimeFromNanoToMillis(long nanoSecond, String format) {
        double value = (double)(System.nanoTime() - nanoSecond) / 1000000.0;
        return new DecimalFormat(format.isEmpty() ? "###.###" : format).format(value);
    }

    static {
        Constructor c = null;
        try {
            Class[] constructorTypes = new Class[]{Integer.TYPE, Integer.TYPE, new char[0].getClass()};
            c = String.class.getDeclaredConstructor(constructorTypes);
            c.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        stringMaker = c == null ? new StringMaker() : new ReflectedStringMaker(c);
    }

    private static class ReflectedStringMaker
    extends StringMaker {
        private final Constructor constructor;

        ReflectedStringMaker(Constructor c) {
            this.constructor = c;
        }

        @Override
        public String getString(char[] buf, int off, int len) {
            if (len < 512) {
                return super.getString(buf, off, len);
            }
            Object[] args = new Object[]{new Integer(off), new Integer(len), buf};
            try {
                return (String)this.constructor.newInstance(args);
            }
            catch (InstantiationException ie) {
                return super.getString(buf, off, len);
            }
            catch (IllegalAccessException iae) {
                return super.getString(buf, off, len);
            }
            catch (InvocationTargetException ite) {
                throw (RuntimeException)ite.getTargetException();
            }
        }
    }

    private static class StringMaker {
        private StringMaker() {
        }

        public String getString(char[] buf, int off, int len) {
            return new String(buf, off, len);
        }
    }
}

