/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import weblogic.utils.PlatformConstants;

public class ErrorCollectionException
extends Exception {
    static final long serialVersionUID = -8925276293755892689L;
    private static final String EOL = PlatformConstants.EOL;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    public ErrorCollectionException() {
    }

    public ErrorCollectionException(String msg) {
        super(msg);
    }

    public ErrorCollectionException(Throwable th) {
        super(th);
        this.errors.add(th);
    }

    public ErrorCollectionException(String msg, Throwable th) {
        super(msg, th);
        this.errors.add(th);
    }

    public void addError(Throwable th) {
        this.errors.add(th);
    }

    public void add(Throwable th) {
        if (th instanceof ErrorCollectionException) {
            this.addCollection((ErrorCollectionException)th);
            return;
        }
        this.addError(th);
    }

    public void addCollection(ErrorCollectionException exceptionCollection) {
        assert (!this.containsNull(exceptionCollection));
        this.errors.addAll(exceptionCollection.getExceptions());
    }

    public int size() {
        return this.errors.size();
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public Collection<Throwable> getExceptions() {
        return this.errors;
    }

    public Iterator<Throwable> getErrors() {
        return this.errors.iterator();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream p) {
        if (this.errors == null || this.errors.isEmpty()) {
            super.printStackTrace(p);
            return;
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(p));
        this.printStackTrace(pw);
        pw.flush();
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        if (this.errors == null || this.errors.isEmpty()) {
            super.printStackTrace(w);
            return;
        }
        w.println("");
        w.println("");
        w.println("There are " + this.errors.size() + " nested errors:");
        w.println("");
        String sep = "";
        for (Throwable t : this.errors) {
            w.print(sep);
            sep = "and" + EOL + EOL;
            t.printStackTrace(w);
            w.println("");
        }
    }

    public String getBaseMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        if (this.errors.isEmpty()) {
            return super.getMessage();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private boolean containsNull(ErrorCollectionException ec) {
        for (Throwable obj : ec.getExceptions()) {
            if (obj != null) continue;
            return true;
        }
        return false;
    }
}

